<?php $__env->startSection('title', 'Blogs | '); ?>
<?php $__env->startSection('content'); ?>
    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">All Blogs</h5>
                        <?php if(Session::has('msg')): ?>
                            <p id="flash-message" class="alert alert-info"><?php echo e(Session::get('msg')); ?></p>
                        <?php endif; ?>
                        <a class="btn btn-sm btn-outline-success float-end" href="<?php echo e(route('blogs.create')); ?>">Add Blog</a>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Title</th>
                                    <th scope="col">Image</th>
                                    <th scope="col">Topic</th>
                                    <th scope="col">Reading Time</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $startIndex = ($blogs->currentPage() - 1) * $blogs->perPage() + 1;
                                ?>
                                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e($startIndex++); ?></th>
                                        <td><?php echo e($blog->title); ?></td>
                                        <td>
                                            <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" alt="Blog Image"
                                                height="50px" width="50px">
                                        </td>
                                        <td><?php echo e($blog->topic); ?></td>
                                        <td><?php echo e($blog->reding_time); ?> mins</td>
                                        <td>
                                            <a href="<?php echo e(route('blogs.edit', $blog->id)); ?>"><i
                                                    class="ri-pencil-fill"></i></a>
                                            <form method="POST" action="<?php echo e(route('blogs.destroy', $blog->id)); ?>"
                                                class="d-inline-block pl-2">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="delete-icon show_confirm"
                                                    data-toggle="tooltip" title='Delete'>
                                                    <i class="ri-delete-bin-2-fill"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php echo e($blogs->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brandsignages/resources/views/admin/blogs/index.blade.php ENDPATH**/ ?>