<?php $__env->startSection('title', 'SEO Management | '); ?>
<?php $__env->startSection('content'); ?>
    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">

                <div class="card">
                    <div class="card-body">

                        <h5 class="card-title">All SEO Entries</h5>
                        <?php if(Session::has('msg')): ?>
                            <p id="flash-message" class="alert alert-info"><?php echo e(Session::get('msg')); ?></p>
                        <?php endif; ?>
                        <a class="btn btn-sm btn-outline-success float-end" href="<?php echo e(route('seo.create')); ?>">Add SEO Entry</a>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Page URL</th>
                                    <th scope="col">Script</th>
                                    <th scope="col">Created At</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $startIndex = ($seos->currentPage() - 1) * $seos->perPage() + 1;
                                ?>
                                <?php $__currentLoopData = $seos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e($startIndex++); ?></th>
                                        <td><?php echo e($seo->page_url); ?></td>
                                        <td><?php echo e(\Illuminate\Support\Str::limit($seo->script, 50)); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($seo->created_at)->isoFormat('Do MMMM YYYY')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('seo.edit', $seo->id)); ?>"><i class="ri-pencil-fill"></i></a>
                                            <form method="POST" action="<?php echo e(route('seo.destroy', $seo->id)); ?>"
                                                class="d-inline-block pl-2">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="delete-icon show_confirm"
                                                    data-toggle="tooltip" title='Delete'>
                                                    <i class="ri-delete-bin-2-fill"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php echo e($seos->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brandsignages/resources/views/admin/seo/index.blade.php ENDPATH**/ ?>