<?php $__env->startSection('title', 'Contacts | '); ?>
<?php $__env->startSection('content'); ?>
    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">All Contacts</h5>
                        
                        <?php if(Session::has('msg')): ?>
                            <p id="flash-message" class="alert alert-info"><?php echo e(Session::get('msg')); ?></p>
                        <?php endif; ?>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Phone</th>
                                    <th scope="col">Message</th>
                                    <th scope="col">Received At</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $startIndex = ($contacts->currentPage() - 1) * $contacts->perPage() + 1;
                                ?>
                                <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e($startIndex++); ?></th>
                                        <td><?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?></td>
                                        <td><?php echo e($contact->email); ?></td>
                                        <td><?php echo e($contact->phone_number); ?></td>
                                        <td><?php echo e(Str::limit($contact->message, 50)); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($contact->created_at)->isoFormat('Do MMMM YYYY, h:mm A')); ?></td>
                                        <td>
                                            <a href="#" class="text-info view-contact" 
                                            data-id="<?php echo e($contact->id); ?>"
                                            data-name="<?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?>"
                                            data-email="<?php echo e($contact->email); ?>"
                                            data-phone="<?php echo e($contact->phone_number); ?>"
                                            data-message="<?php echo e($contact->message); ?>"
                                            data-received="<?php echo e(\Carbon\Carbon::parse($contact->created_at)->isoFormat('Do MMMM YYYY, h:mm A')); ?>"
                                            data-bs-toggle="modal" 
                                            data-bs-target="#contactModal">
                                             <i class="ri-eye-fill"></i>
                                         </a>
                                            <form method="POST" action="<?php echo e(route('contacts.destroy', $contact->id)); ?>" class="d-inline-block">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="delete-icon show_confirm" data-toggle="tooltip" title="Delete">
                                                    <i class="ri-delete-bin-2-fill text-danger"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <?php echo e($contacts->links()); ?>

                        <!-- End Table -->
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Details Modal -->
    <div class="modal fade" id="contactModal" tabindex="-1" aria-labelledby="contactModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="contactModalLabel">Contact Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Name:</strong> <span id="contact-name"></span></p>
                    <p><strong>Email:</strong> <span id="contact-email"></span></p>
                    <p><strong>Phone:</strong> <span id="contact-phone"></span></p>
                    <p><strong>Message:</strong> <span id="contact-message"></span></p>
                    <p><strong>Received At:</strong> <span id="contact-received"></span></p>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap JS (Ensure it's included AFTER jQuery) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function () {
            $(".view-contact").click(function () {
                let name = $(this).data("name");
                let email = $(this).data("email");
                let phone = $(this).data("phone");
                let message = $(this).data("message");
                let received = $(this).data("received");

                $("#contact-name").text(name);
                $("#contact-email").text(email);
                $("#contact-phone").text(phone);
                $("#contact-message").text(message);
                $("#contact-received").text(received);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brandsignages/resources/views/admin/query/contacts.blade.php ENDPATH**/ ?>