@extends('frontend.layout.appLayout')
@section('content')
<section class="carousel-section">
    <div id="imageCarousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#imageCarousel" data-bs-slide-to="0" class="active"
                aria-current="true" aria-label="Slide 1"></button>
            <button type="button" data-bs-target="#imageCarousel" data-bs-slide-to="1"
                aria-label="Slide 2"></button>
            
        </div>

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-.webp')}}" alt="Premium Acrylic Sign Boards in Mumbai">
                <div class="carousel-caption-custom">
                    <h1>Premium Acrylic Sign Boards in Mumbai</h1>
                    <button class="custom-btn">Know More</button>
                </div>
            </div>

            <div class="carousel-item">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-1.webp')}}" alt="Acrylic Sign Boards in Mumbai">
                <div class="carousel-caption-custom">
                    <h1>Premium Acrylic Sign Boards in Mumbai</h1>
                    <button class="custom-btn">Know More</button>
                </div>
            </div>

            
        </div>
    </div>
</section>


<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Acrylic Sign Boards in Mumbai – Our Expertise</h2>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-2.webp')}}" alt="Acrylic Sign Boards" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <p class="brand-description">
                  Acrylic signages are the symbol of sophistication and elegance, making them a popular choice for businesses looking to uplift their branding. Known for their sleek, glass-like transparent appearance, acrylic signboards offer a professional look while being lightweight and weather-resistant. 
                                </p>
                <p class="brand-description">
                    At Brand Signages, we focus on designing premium-quality acrylic sign boards. Whether you're seeking acrylic letter signs or a transparent acrylic sign board we are the first choice for top businesses. From acrylic signs to glowing acrylic LED sign boards, our team merges innovation with updated technology to design signs that improve observability. We produce custom acrylic signs personalized to your branding needs. 
                </p>
                <p class="brand-description">Our services encircle a huge collection of sign work, comprising acrylic glow signs, letter signs, and acrylic LED signage. With 10+ years of experience in designing acrylic signs for multiple industries, we maintain standards. Our brand new collection of acrylic LED signages is crafted to allure your viewers, day and night. Collaborate with us on all your acrylic signboard requirements in Mumbai. Let us bring your brand to existence with beautiful sign boards that shed light.
                </p>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Types of Acrylic Sign Boards We Offer</h2>
            <p class="card-text text-center">We focus on rendering standardized acrylic sign boards in Mumbai for several industries. Whether you require a neon sign, a glow sign board, or a custom acrylic letter sign, our proficiency ensures incredible outcomes. Opt for us for all your acrylic signage requirements, and let our inventive designs uplift your business presence!</p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-3.webp')}}" class="why-card-img-top"
                        alt="Custom Acrylic Signs    ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Custom Acrylic Signs    </h3>
                        <p class="card-text">Customize your brand with our custom acrylic signs. These signs are outlined to fit  your particular desires, whether it's for a storefront, office, or event. From black acrylic signs to colorful patterns, our sign work ensures your visualization is brought to existence.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-4.webp')}}" class="why-card-img-top"
                        alt="Illuminated Acrylic Sign Boards ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Illuminated Acrylic Sign Boards </h3>
                        <p class="card-text">Impry observability day and night with our illuminated acrylic sign boards. Illustrating acrylic LED and glow sign boards, these are ideal for organizations that wish to be different from the rest. Our LED signage and neon sign boards give a vibrant feel to any situation.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-5.webp')}}" class="why-card-img-top"
                            alt=" 3D Acrylic Letter Signs">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3"> 3D Acrylic Letter Signs</h3>
                            <p class="card-text">Make an impact with 3D acrylic letter signs that give depth and elegance. Whether it’s acrylic letters or letter signs integrated with stainless steel, these are perfect for producing a competent outlook. Ideal for indoor or outdoor signs, they exhibit your brand with sophistication.</p>
                        </div>
                    </div>
            </div>
            
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-6.webp')}}" class="why-card-img-top"
                        alt="Acrylic Logo Signs ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Acrylic Logo Signs </h3>
                        <p class="card-text">Spotlight your brand with acrylic logo signs that evade standards and innovation. These acrylic signs can be tailored to streamline your brand colors and designs, making them an ideal center of attraction for your enterprise.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-7.webp')}}" class="why-card-img-top"
                        alt="Outdoor Acrylic Sign Boards   ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Outdoor Acrylic Sign Boards   </h3>
                        <p class="card-text"> Weather-proof and long-lasting, our outdoor acrylic sign boards are shaped for long-run usage. From black acrylic signage to LED sign boards, they are perfect for retail outlets, restaurants, and offices. They retain their fascination while withstanding the components.</p>
                    </div>
                </div>
            </div>
        </div>

        <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-3.webp')}}" class="why-card-img-top"
                                    alt="Custom Acrylic Signs    ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Custom Acrylic Signs    </h3>
                                    <p class="card-text">Customize your brand with our custom acrylic signs. These signs are outlined to fit  your particular desires, whether it's for a storefront, office, or event. From black acrylic signs to colorful patterns, our sign work ensures your visualization is brought to existence.</p>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-4.webp')}}" class="why-card-img-top"
                                    alt="Illuminated Acrylic Sign Boards ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Illuminated Acrylic Sign Boards </h3>
                                    <p class="card-text">Impry observability day and night with our illuminated acrylic sign boards. Illustrating acrylic LED and glow sign boards, these are ideal for organizations that wish to be different from the rest. Our LED signage and neon sign boards give a vibrant feel to any situation.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-5.webp')}}" class="why-card-img-top"
                                    alt=" 3D Acrylic Letter Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3"> 3D Acrylic Letter Signs</h3>
                                    <p class="card-text">Make an impact with 3D acrylic letter signs that give depth and elegance. Whether it’s acrylic letters or letter signs integrated with stainless steel, these are perfect for producing a competent outlook. Ideal for indoor or outdoor signs, they exhibit your brand with sophistication.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-5.webp')}}" class="why-card-img-top"
                                    alt=" 3D Acrylic Letter Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3"> 3D Acrylic Letter Signs</h3>
                                    <p class="card-text">Make an impact with 3D acrylic letter signs that give depth and elegance. Whether it’s acrylic letters or letter signs integrated with stainless steel, these are perfect for producing a competent outlook. Ideal for indoor or outdoor signs, they exhibit your brand with sophistication.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-6.webp')}}" class="why-card-img-top"
                                    alt="Acrylic Logo Signs ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Acrylic Logo Signs </h3>
                                    <p class="card-text"> Spotlight your brand with acrylic logo signs that evade standards and innovation. These acrylic signs can be tailored to streamline your brand colors and designs, making them an ideal center of attraction for your enterprise.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-7.webp')}}" class="why-card-img-top"
                                    alt="Outdoor Acrylic Sign Boards   ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Outdoor Acrylic Sign Boards   </h3>
                                    <p class="card-text"> Weather-proof and long-lasting, our outdoor acrylic sign boards are shaped for long-run usage. From black acrylic signage to LED sign boards, they are perfect for retail outlets, restaurants, and offices. They retain their fascination while withstanding the components.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="why-carousel-controls">
                <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators why-carousel-indicators">
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>



<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Why Choose Us for Acrylic Sign Boards?</h2>
        {{-- <p class="card-text text-center">As one of the best sign board manufacturers in Mumbai, we supply a variety of sign boards to fit in your organizational requirements. Here are the various kinds of sign boards we produce:</p> --}}

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-8.webp')}}" alt="Personalized Designs  " class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Personalized Designs  </h2>
                <p class="brand-description">
                    We produce acrylic sign boards that depict your brand’s recognition. Whether you require acrylic letters, a fashionable neon sign board, or a lively glow sign, our team personalized each detail to fulfill your needs.
                </p>
                <h2 class="brand-title">Premium Quality Materials  </h2>
                <p class="brand-description">
                    Our acrylic signage is designed utilizing long-lasting substances such as black acrylic and stainless steel. We confirm your acrylic sign board is not only visually attractive but also made to persist. 
                </p>
                <h2 class="brand-title">Expert Artistry </h2>
                <p class="brand-description">
                    Our expert professionals shine in making unique sign work. From complicated acrylic letter signs to bright LED sign boards, each project exhibits accuracy and inventiveness.
                               </p>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">

        <div class="row align-items-center">

            <div class="col-lg-6 order-2 order-lg-1">
                <h2 class="brand-title">Reasonable Pricing</h2>
                <p class="brand-description">
                    
                    We have faith in providing high-class acrylic sign boards in Mumbai at combative prices. Whether it’s a custom acrylic sign or a usual outdoor sign, you get extraordinary worth for your money.
                </p>
                <h2 class="brand-title">2-Year Warranty   </h2>
                <p class="brand-description">
                    Each acrylic sign we produce is available with a 2-year warranty. This assurance ensures longevity and rendition, consisting of acrylic LED signs and glow sign boards.
                </p>
                <h2 class="brand-title">Time Delivery and Installation</h2>
                <p class="brand-description">
                    Time is precious, and we make sure that there is timely delivery of all sign boards. Our team also offers trouble-free installation, be it a black acrylic sign, a neon sign, or a signage board.
                                </p>
            </div>

            <div class="col-lg-6 mb-4 mb-lg-0  order-1 order-lg-2">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-9.webp')}}" alt="Acrylic Sign Boards in Mumbai" class="img-fluid">
                </div>
            </div>

        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-10.webp')}}" alt="Acrylic Sign Boards in Mumbai" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Huge Array of Alternatives </h2>
                <p class="brand-description">
                    We provide a variety of signage, comprising acrylic LED signs, letter signs, LED signage, and standard acrylic designs. From contemporary acrylic letters to polished outdoor signs, we serve divergent requirements.
                </p>
                <p class="brand-description">Select Brand Signage for top-quality acrylic sign boards in Mumbai. Our integration of proficiency, quality substances, and cost-effective pricing makes certain that your brand gets observed in the best method possible. Let’s make your dream come true with stunning acrylic sign boards!
                </p>
            </div>
        </div>
    </div>
</section>

<section class="mt-lg-5">
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3" id="gallery-container">
        <h2 class="hero-title">Catalogue</h2>
        
        <!-- First Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-18.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-18.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai" style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-11.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-11.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-12.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-12.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-13.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-13.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
        </div>
        
        <!-- Second Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-14.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-14.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-15.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-15.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-16.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-16.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-17.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/premium-acryliv-sign-boards-in-mumbai-17.webp')}}" class="img-fluid" alt="Acrylic Sign Boards in Mumbai"  style="width: 100%;">
                </a>
            </div>
        </div>

    </div>
</section>

<section class="testimonial section ">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The acrylic sign board we bought was terrific! The grade and varnish of the acrylic letters went beyond our expectations. Highly commendable for organizations in Mumbai!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                           
                            <div>
                                <div class="client-name">Ramesh Mehta</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">Their acrylic LED signs and glow sign boards are a crucial moment. The artistry is flawless, and they delivered exactly on time. A big thumbs up!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <div>
                                <div class="client-name">Anita Sharma</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">“I was intrigued with their collection of acrylic sign boards. The black acrylic sign we selected is fashionable as well as resistant. Excellent job on the installation!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            
                            <div>
                                <div class="client-name">Vikas Gupta</div>
                              
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The team generated a remarkable letter sign for our office. The integration of stainless steel and acrylic signage gave it a superior outlook. Unique service!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            
                            <div>
                                <div class="client-name">Sneha Patel</div>
                             
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">“Their custom acrylic signs were ideal for our branding requirements. The neon signboard has attached a dynamic feel to our outlet. Wonderful sign work!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            
                            <div>
                                <div class="client-name">Rahul Desai</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The acrylic signage board we bought from this signage company in Mumbai entirely modified our office! The design and installation were ideal. Highly suggested!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                      
                                        <div>
                                            <div class="client-name">Ramesh Mehta</div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Their acrylic LED signs and glow sign boards are a crucial moment. The artistry is flawless, and they delivered exactly on time. A big thumbs up!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Anita Sharma</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“I was intrigued with their collection of acrylic sign boards. The black acrylic sign we selected is fashionable as well as resistant. Excellent job on the installation!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Vikas Gupta</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“I was intrigued with their collection of acrylic sign boards. The black acrylic sign we selected is fashionable as well as resistant. Excellent job on the installation! <br> <br> </p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Vikas Gupta</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The team generated a remarkable letter sign for our office. The integration of stainless steel and acrylic signage gave it a superior outlook. Unique service!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Sneha Patel</div>
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“Their custom acrylic signs were ideal for our branding requirements. The neon signboard has attached a dynamic feel to our outlet. Wonderful sign work!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Rahul Desai</div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>

            <div class="testimonial-carousel-controls">
                <button id="prevButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators testimonial-carousel-indicators">
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>



<section class="faq-section">
    <div class="faq-container">
        <h1 class="faq-title">FAQS</h1>

        <div class="faq-item">
            <button class="faq-question">
                Where can I get standardized acrylic sign boards in Mumbai? 
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>You can avail of high-class acrylic sign boards in Mumbai through trustworthy sign makers emphasizing acrylic signage. We provide a variety of alternatives, comprising acrylic LED signs, neon sign boards, and acrylic letters, customized to your business requirements.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What is the price of acrylic letter sign boards in Mumbai?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>The price of acrylic letter sign boards is based on size, design, and substances such as black acrylic or stainless steel. For exact pricing, call for a quote for your custom acrylic signage or outdoor signs.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What are the benefits of utilizing acrylic sign boards for my business?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Acrylic sign boards provide a glossy, qualified appearance, longevity, and flexibility. Whether it’s a glow sign board, letter sign, or LED signage, they efficiently allure customers and promote your brand’s existence.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                How resistant are acrylic sign boards in comparison to other substances?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Acrylic signs are highly persistent and weather-proof, making them ideal for outdoor signs. They maintain their glow and class longer than customary substances, specifically with alternatives such as acrylic LED signs.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Can acrylic sign boards be personalized for exceptional designs and branding?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Yes, of course! Acrylic sign boards can be tailored to suit your brand’s recognition. Whether you require custom acrylic signs, acrylic letter signs, or black acrylic signage, our sign work ensures extraordinary, spectacular designs.</p>
            </div>
        </div>

    </div>
</section>

@endsection