@extends('frontend.layout.appLayout')
@section('content')



<section class="carousel-section">
 

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-1.webp')}}" alt="Prohibition Signs for Workplace Safety">
                <div class="carousel-caption-custom">
                    <h1>Leading Digital Signages Manufacturer in Chennai</h1>
                     <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                </div>
            </div>

       

            
        </div>
    </div>
</section>
<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Digital Display Boards for Businesses in Chennai        </h2>
       

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-2.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">#1 Digital Signage Company in Chennai                 </h2>
                <p class="brand-description">
                    In the digital age, digital display boards have become an indispensable tool for businesses aiming to engage their audience and amplify their brand presence. Digital signages help businesses effectively deliver promotions, announcements, and essential information with better visibility and impact. From retail outlets to corporate offices and hospitality sectors, digital signage offers versatile applications that help businesses stay ahead of the curve. 

                    </p>
                <p class="brand-description">
                    Brand Signages, a leading digital <a href="{{route('signage_company_in_chennai')}}" style="text-decoration: unset;color:#E43D12;font-weight: bold;">signage manufacturers in Chennai</a>, offers innovative solutions, including LED sign boards, digital kiosks, and interactive displays. We design interactive digital display boards to elevate communication and improve customer experiences. Whether it’s a wall-mounted digital display or a free-standing signage kiosk, Brand Signages Chennai-based digital signage vendor to meet your specific needs, creating a visually stunning way to interact with customers.

                </p>
                <p class="brand-description">
                    Choosing digital signage solutions from Brand Signages means investing in a cost-effective and long-term marketing tool. These solutions offer real-time updates, reducing the need for printed materials and ensuring your message is always relevant. Whether you're looking to enhance customer engagement in retail, hospitality, or any other industry, partnering with us ensures your business stands out with professional, high-quality solutions.

                </p>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Why Choose Us for Digital Signage Services in Chennai?</h2>
            <p class="card-text text-center">Choosing Brand Signages as your digital signage manufacturer in Chennai ensures cutting-edge designs and seamless integration to enhance your brand’s visibility. As a reliable digital signage display manufacturer, we focus on providing inventive and standardized solutions personalized to fulfill your business needs. Here’s why we are the selected preference for digital signage solutions in Chennai:</p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-3.webp')}}" class="why-card-img-top"
                        alt="High-Resolution Displays">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">High-Resolution Displays</h3>
                        <p class="card-text">Our LED signs, video walls, and digital signboards provide translucent visuals for the ultimate impression. High-definition digital signage displays guarantee your content is distinct, for indoor as well as outdoor usage.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-4.webp')}}" class="why-card-img-top"
                        alt="Customizable Features">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Customizable Features</h3>
                        <p class="card-text">We offer personalized signage solutions to fit your brand’s exceptional requirements, comprising neon signs, digital standees, and touchscreen signage kiosks. Seamlessly tailor content with our dynamic content management systems for prompt updates and customized messaging. </p>
                    </div>
                </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-5.webp')}}" class="why-card-img-top"
                            alt="Indoor and Outdoor Options">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Indoor and Outdoor Options</h3>
                            <p class="card-text">Our collection consists of wall-mounted signage displays and screen kiosks for an indoor atmosphere. For outdoor places, we provide weather-resistant technology to confirm resistant and dependable performance. From small indoor surroundings to huge LED video walls for outdoor events, we have solutions for each need.</p>
                        </div>
                    </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-6.webp')}}" class="why-card-img-top"
                        alt="Weather-Resistant Technology">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Weather-Resistant Technology</h3>
                            <p class="card-text">Our LED sign boards and advertising displays are made to bear rough weather situations. With modern substances, your sign boards stay comprehensive and operational, even in demanding surroundings.
                            </p>
                        </div>
                    </div>
            </div>
          
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-7.webp')}}" class="why-card-img-top"
                        alt="Touchscreen Displays ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Touchscreen Displays </h3>
                        <p class="card-text">Involve your viewers with communicative touchscreen displays and digital signage kiosks. Ideal for signage kiosks in retail, hospitality, and corporate areas. These touchscreen signage displays offer a magnetic and easy-to-operate experience, augmenting customer engagement. </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-8.webp')}}" class="why-card-img-top"
                        alt="Dynamic Content Management">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Dynamic Content Management</h3>
                        <p class="card-text">Handle your digital signage displays seamlessly with our easy-to-handle content management equipment. Whether it’s an LED video wall, display signage, or a digital signage solution, you can refurbish content in actual time with comfort. Plan and alter your advertising content from a distance, saving time and improving effectiveness.</p>
                    </div>
                </div>
            </div>
        </div>

        <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-3.webp')}}" class="why-card-img-top"
                                    alt="High-Resolution Displays">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">High-Resolution Displays</h3>
                                    <p class="card-text">Our LED signs, video walls, and digital signboards provide translucent visuals for the ultimate impression. High-definition digital signage displays guarantee your content is distinct, for indoor as well as outdoor usage.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-4.webp')}}" class="why-card-img-top"
                                    alt="Customizable Features">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customizable Features</h3>
                                    <p class="card-text">We offer personalized signage solutions to fit your brand’s exceptional requirements, comprising neon signs, digital standees, and touchscreen signage kiosks. Seamlessly tailor content with our dynamic content management systems for prompt updates and customized messaging. </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Indoor and Outdoor Options">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Indoor and Outdoor Options</h3>
                                    <p class="card-text">
                                        Our collection consists of wall-mounted signage displays and screen kiosks for an indoor atmosphere. For outdoor places, we provide weather-resistant technology to confirm resistant and dependable performance. From small indoor surroundings to huge LED video walls for outdoor events, we have solutions for each need.

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Weather-Resistant Technology">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Weather-Resistant Technology</h3>
                                    <p class="card-text">Our LED sign boards and advertising displays are made to bear rough weather situations. With modern substances, your sign boards stay comprehensive and operational, even in demanding surroundings.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-7.webp')}}" class="why-card-img-top"
                                    alt="Touchscreen Displays ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Touchscreen Displays </h3>
                                    <p class="card-text">Involve your viewers with communicative touchscreen displays and digital signage kiosks. Ideal for signage kiosks in retail, hospitality, and corporate areas. These touchscreen signage displays offer a magnetic and easy-to-operate experience, augmenting customer engagement. </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-8.webp')}}" class="why-card-img-top"
                                    alt="Dynamic Content Management">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Dynamic Content Management</h3>
                                    <p class="card-text">Handle your digital signage displays seamlessly with our easy-to-handle content management equipment. Whether it’s an LED video wall, display signage, or a digital signage solution, you can refurbish content in actual time with comfort. Plan and alter your advertising content from a distance, saving time and improving effectiveness.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="why-carousel-controls">
                <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators why-carousel-indicators">
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Applications of Digital Signages </h2>
        <p class="card-text text-center">Digital signage has modified the manner in which enterprises and organizations interact with their audiences. They provide a universal and influential process to depict information, advertisements, and proclamations. As a prominent digital signage manufacturer in Chennai, we offer high-class digital signage solutions in Chennai to serve multiple industries. Here are some main applications of digital sign boards and digital display boards</p>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-9.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Retail and Shopping Malls </h2>
                <p class="brand-description">
                    <ul>
                        <li>Allure customers with engaging LED signs, digital standees, and video walls illustrating promotions and transactions.  </li>
                        <li>Touch screen signage kiosks enhance customer communication and offer self-service alternatives for product searches or wayfinding.  </li>
                        <li>Produce a comprehensive shopping experience with advertising displays and wall-mounted signage displays.</li>
                    </ul>
                </p>
                <h2 class="brand-title">Hospitals and Healthcare</h2>
                <p class="brand-description">
                   
                    <ul>
                        <li>Utilize digital signage displays for wayfinding, proclamations, and patient education.  </li>
                        <li>Screen kiosks and digital sign boards in waiting zones offer immediate updates on doctor attainability and planners.  </li>
                        <li>Improve interaction with guests by utilizing LED signboards and signage kiosks for significant health messages.</li>
                    </ul>
                </p>
               
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">

        <div class="row align-items-center">

            <div class="col-lg-6 order-2 order-lg-1">
                <h2 class="brand-title">Corporate Offices</h2>
                <p class="brand-description">
                    
                    <ul>
                        <li>Showcase company updates, workers' achievements, or meeting planners on digital display boards and LED video walls.  </li>
                        <li>Digital signage solutions promote internal interaction with visually attractive and promptly updatable content.  </li>
                        <li>Improve branding with polished neon signs and professional digital standees.</li>
                    </ul>
                </p>
                <h2 class="brand-title">Educational Institutions</h2>
                <p class="brand-description">
                  
                    <ul>
                        <li>Instill digital signages for proclamations, event planners, and campus steerage.  </li>
                        <li>Utilize sign boards and touchscreen signage kiosks for communicative learning and data distribution.  </li>
                        <li>Utilize sign boards and touchscreen signage kiosks for communicative learning and data distribution.  </li>
                    </ul>
                
                </p>
            </div>

            <div class="col-lg-6 mb-4 mb-lg-0  order-1 order-lg-2">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-10.jpg')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

        </div>
    </div>
</section>



<section class="why-bg-light-pink py-5" style="background-color: #fff;">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Benefits of Digital Signages for Business </h2>
            <p class="card-text text-center">Digital signage is transforming the way organizations interact with their viewers. They merge technology and innovation to deliver influential messages that allure awareness and engross customers. Here are the major advantages of utilizing digital signage for your business:            </p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-11.webp')}}" class="why-card-img-top"
                        alt="Improved Brand Visibility">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Improved Brand Visibility</h3>
                        <p class="card-text">
                            LED signs, neon signs, and video walls pull attention with their vibrant and comprehensive displays. A well-positioned digital signboard or digital standee can make your brand more remarkable. Made-to-order display signage sanctions enterprises to line up content with their brand recognition.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-12.webp')}}" class="why-card-img-top"
                        alt="Real-Time Information Sharing">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Real-Time Information Sharing</h3>
                        <p class="card-text">
                            Digital signage displays facilitate prompt updates, making it simple to share promotions or proclamations.  Signage kiosks and screen kiosks are ideal for offering touch-enabled immediate data. With digital signage solutions in Chennai, organizations can customize messages for several times and audiences.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-13.webp')}}" class="why-card-img-top"
                        alt="Cost-Effective Solutions">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Cost-Effective Solutions</h3>
                        <p class="card-text">
                            LED displays and advertising displays minimize printing costs for custom sign boards. Wall-mounted signage displays are long-lasting and need the least upkeep. Digital signage kiosks and LED video walls provide long-run worth by supplying high-class visuals.
                        </p>
                    </div>
                </div>
            </div>
            
            
        </div>

        <div id="signageCarouselNew" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-11.webp')}}" class="why-card-img-top"
                                    alt="Improved Brand Visibility">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Improved Brand Visibility</h3>
                                    <p class="card-text">
                                        LED signs, neon signs, and video walls pull attention with their vibrant and comprehensive displays. A well-positioned digital signboard or digital standee can make your brand more remarkable. Made-to-order display signage sanctions enterprises to line up content with their brand recognition.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-12.webp')}}" class="why-card-img-top"
                                    alt="Real-Time Information Sharing">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Real-Time Information Sharing</h3>
                                    <p class="card-text">
                                        Digital signage displays facilitate prompt updates, making it simple to share promotions or proclamations.  Signage kiosks and screen kiosks are ideal for offering touch-enabled immediate data. With digital signage solutions in Chennai, organizations can customize messages for several times and audiences.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-13.webp')}}" class="why-card-img-top"
                                    alt="Cost-Effective Solutions">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Cost-Effective Solutions</h3>
                                    <p class="card-text">
                                        LED displays and advertising displays minimize printing costs for custom sign boards. Wall-mounted signage displays are long-lasting and need the least upkeep. Digital signage kiosks and LED video walls provide long-run worth by supplying high-class visuals.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              
            </div>

          
        </div>
    </div>
</section>
<section class="mt-lg-5">
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3" id="gallery-container">
        <h2 class="hero-title">Catalogue</h2>
        
        <!-- First Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-14.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-14.webp')}}" class="img-fluid" alt="Catalogue" style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-15.webp')}}" data-lightbox="catalogue" data-title="Image 2">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-15.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-16.webp')}}" data-lightbox="catalogue" data-title="Image 3">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-16.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-17.webp')}}" data-lightbox="catalogue" data-title="Image 4">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-17.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>
        
        <!-- Second Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/led-sign-18.webp')}}" data-lightbox="catalogue" data-title="Image 5">
                <img src="{{asset('frontend/Images/new/led-sign-18.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-18.webp')}}" data-lightbox="catalogue" data-title="Image 6">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-18.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-19.webp')}}" data-lightbox="catalogue" data-title="Image 7">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-19.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-20.webp')}}" data-lightbox="catalogue" data-title="Image 8">
                <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-20.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>

    </div>
</section>

<section class="testimonial section ">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">“The digital sign board which we bought has been a transformative breakthrough for our outlet. The LED signs are extensive, and customers generally admire our advertising displays. Highly suggest their signage solutions!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-21.webp')}}" alt="Ananya R" class="client-img">
                            <div>
                                <div class="client-name">Ananya R</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">We required persistent digital signages for our hospital, and this company supplied us. The screen kiosks and touch screen displays in the lobby have enhanced patient steerage considerably.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-22.webp')}}" alt="Rahul M" class="client-img">
                            <div>
                                <div class="client-name">Rahul M</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">Their digital signage displays are unique for internal interaction. From video walls** to neon signs, they have everything. The team offered marvelous guidance throughout.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-23.webp')}}" alt="Nisha S" class="client-img">
                            <div>
                                <div class="client-name">Nisha S</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The digital signage kiosk and LED video walls they placed at our shopping center have improved customer engagement. The comprehensive content aspects are simple to utilize and update.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-24.webp')}}" alt="Arjun T" class="client-img">
                            <div>
                                <div class="client-name">Arjun T</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The digital standees and sign boards are ideal for our campus. Students and workers feel that the digital display boards are very knowledgeable and involved. Great service!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-25.webp')}}" alt="Priya K" class="client-img">
                            <div>
                                <div class="client-name">Priya K</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“The digital sign board which we bought has been a transformative breakthrough for our outlet. The LED signs are extensive, and customers generally admire our advertising displays. Highly suggest their signage solutions!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-21.webp')}}" alt="Ananya R" class="client-img">
                                        <div>
                                            <div class="client-name">Ananya R</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">We required persistent digital signages for our hospital, and this company supplied us. The screen kiosks and touch screen displays in the lobby have enhanced patient steerage considerably.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-22.webp')}}" alt="Rahul M" class="client-img">
                                        <div>
                                            <div class="client-name">Rahul M</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Their digital signage displays are unique for internal interaction. From video walls** to neon signs, they have everything. The team offered marvelous guidance throughout.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-23.webp')}}" alt="Nisha S" class="client-img">
                                        <div>
                                            <div class="client-name">Nisha S</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Their digital signage displays are unique for internal interaction. From video walls** to neon signs, they have everything. The team offered marvelous guidance throughout.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-23.webp')}}" alt="Nisha S" class="client-img">
                                        <div>
                                            <div class="client-name">Nisha S</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The digital signage kiosk and LED video walls they placed at our shopping center have improved customer engagement. The comprehensive content aspects are simple to utilize and update.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-24.webp')}}" alt="Arjun T" class="client-img">
                                        <div>
                                            <div class="client-name">Arjun T</div>
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The digital standees and sign boards are ideal for our campus. Students and workers feel that the digital display boards are very knowledgeable and involved. Great service!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/leading-digital-signages-manufacturer-in-chennai-25.webp')}}" alt="Priya K" class="client-img">
                                        <div>
                                            <div class="client-name">Priya K</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="testimonial-carousel-controls">
                <button id="prevButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators testimonial-carousel-indicators">
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>



<section class="faq-section">
    <div class="faq-container">
        <h1 class="faq-title">FAQS</h1>

        <div class="faq-item">
            <button class="faq-question">
                What kinds of digital sign boards do you provide?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>We provide a huge collection of digital sign boards, comprising LED signs, neon signs, digital standees, video walls, and touch screen signage kiosks. Whether you require an advertising display or a wall-mounted signage display, we have alternatives for indoor as well as outdoor implementations.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Can your digital signage solutions be tailored for particular industries?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Yes, our digital signage solutions are entirely made-to-order. We offer customized sign boards and digital signage displays to fit several industries such as retail, healthcare, education, and corporate offices. Characteristics such as prompt updates, communicative content, and traditional designs make sure of the ideal fit for your organization’s requirements. 
                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What is the approximate life cycle of your digital display boards?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    Our digital display boards are outlined for resistance and dependability, providing an approximate life cycle of 50,000 to 100,000 hours. Modern LED sign boards and substances guarantee durable performance. 
                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Do you offer installation and after-sales guidance in Chennai? 
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                     Definitely. We provide expert installation services for all our digital signage displays and signage kiosks in Chennai. Our after-sales assistance consists of upkeep, troubleshooting, and updates to maintain your digital signage function well.

                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                How energy-saving is your digital signage?

                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Our digital signage solutions are highly energy-saving, using modern LED signage technology. This minimizes power absorption while retaining lively, extensive visuals, making them an eco-friendly preference for your enterprise.
                </p>
            </div>
        </div>
       
    </div>
</section>

@endsection