@extends('frontend.layout.appLayout')
@section('content')



<section class="carousel-section">
 

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-1.webp')}}" alt="Hospital & Medical Signages Chennai">
                <div class="carousel-caption-custom">
                    <h1>Hospital & Medical Signages Chennai</h1>
                     <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                </div>
            </div>

       

            
        </div>
    </div>
</section>
<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Importance of Medical & Hospital Signages for Healthcare Facilities  </h2>
       

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-2.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <p class="brand-description">
                    Medical signages play an important part in making certain of the effortless working of healthcare accommodations. From improving patient experiences to enhancing security, well-planned hospital signages in Chennai are crucial for generating a patient-friendly atmosphere.One of the major advantages of healthcare signs is their capability to improve the patient experience. Transparent and instructive signage boards in hospitals assist patients steer the premises with comfort, minimizing chaos and tension. Whether it’s an LED sign specifying departments or a sign board showcasing emergency contact instructions, these instruments make sure that patients and guests feel more relaxed and aware.  
                    </p>
                <p class="brand-description">
                    Efficient hospital signage also smoothens wayfinding and steering. In large enterprises, looking for the appropriate department or room can be disturbing. Instructional LED signage and sign boards judiciously positioned at entry points, elevators, and corridors make steerage easy and effective. This not only saves time but also assists employees to handle patient flow better.Moreover, medical signages in Chennai play a crucial role in enhancing security and abidance. From exhibiting security protocols to marking constrained sectors, these sign boards support retaining a secure and regulated atmosphere. Hospitals can also utilize general LED signage to pinpoint emergency exits, hygiene practices, and fire safety steps, guaranteeing compliance with healthcare norms.For hospitals and clinics, funding in high-class sign board manufacturers and LED signage solutions is a critical movement toward enhanced service and operational effectiveness.
                  </p>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Why Choose Us for Hospital Signages in Chennai?</h2>
            <p class="card-text text-center">We focus on generating standardized hospital signages in Chennai customized to the exceptional requirements of healthcare accommodations. With a dedication to brilliance and attention to minute things, we render medical signages that promote steerage, security, and an all-rounded patient experience. Our healthcare signs are outlined to be both operational and visually attractive. </p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-3.webp')}}" class="why-card-img-top"
                        alt="Expertise You Can Trust">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Expertise You Can Trust</h3>
                        <p class="card-text">Our team has comprehensive experience in outlining and producing hospital signage for clinics, hospitals, and healthcare places.We work closely with clients to generate personalized signage boards that satisfy particular needs.From LED signage to classy sign boards, we ensure accuracy and standards.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-4.webp')}}" class="why-card-img-top"
                        alt="Quick Turnaround Time  ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Quick Turnaround Time  </h3>
                        <p class="card-text">We concentrate on punctual delivery of all medical signages in Chennai without adjusting to class.Our smooth methods confirm that you get your healthcare signs installed immediately.Trust us for effective service, be it a small signboard or intricate LED signage.  </p>
                    </div>
                </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-5.webp')}}" class="why-card-img-top"
                            alt="Affordable Pricing">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Affordable Pricing</h3>
                            <p class="card-text">We focus on custom LED signs to depict your brand recognition. Whether you require an outdoor display, an LED video wall, or an exceptional LED digital solution, we produce designs that pull attention. Adjustable alternatives to fit any place, from compact display signs to huge industrial LED displays customized for influence.</p>
                        </div>
                    </div>
            </div>
           
        
       
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-6.webp')}}" class="why-card-img-top"
                        alt="Compliance with Industry Standards">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Compliance with Industry Standards</h3>
                        <p class="card-text">All our signage boards comply with healthcare rules and security protocols.We utilize resistant substances and modern technology to produce submissive and dependable hospital signage.Our LED signs and signboards guarantee transparent observability and durable performance. </p>
                    </div>
                </div>
            </div>

        </div>

        <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-3.webp')}}" class="why-card-img-top"
                                    alt="Expertise You Can Trust">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Expertise You Can Trust</h3>
                                    <p class="card-text">Our team has comprehensive experience in outlining and producing hospital signage for clinics, hospitals, and healthcare places.We work closely with clients to generate personalized signage boards that satisfy particular needs.From LED signage to classy sign boards, we ensure accuracy and standards.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-4.webp')}}" class="why-card-img-top"
                                    alt="Quick Turnaround Time  ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Quick Turnaround Time  </h3>
                                    <p class="card-text">We concentrate on punctual delivery of all medical signages in Chennai without adjusting to class.Our smooth methods confirm that you get your healthcare signs installed immediately.Trust us for effective service, be it a small signboard or intricate LED signage.  </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Affordable Pricing">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Affordable Pricing</h3>
                                    <p class="card-text">
                                        We provide combative pricing for all kinds of hospital signages, making them attainable for all healthcare enterprises.Our affordable solutions comprise both signboard manufacturers and LED signage alternatives.High-class designs at pocket-friendly prices make us distinct. 

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-4.webp')}}" class="why-card-img-top"
                                    alt="Affordable Pricing">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Quick Turnaround Time</h3>
                                    <p class="card-text">We concentrate on punctual delivery of all medical signages in Chennai without adjusting to class.Our smooth methods confirm that you get your healthcare signs installed immediately.Trust us for effective service, be it a small signboard or intricate LED signage.  
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Affordable Pricing">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Affordable Pricing</h3>
                                    <p class="card-text">
                                        We provide combative pricing for all kinds of hospital signages, making them attainable for all healthcare enterprises.Our affordable solutions comprise both signboard manufacturers and LED signage alternatives.High-class designs at pocket-friendly prices make us distinct. 

                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-6.webp')}}" class="why-card-img-top"
                                alt="Compliance with Industry Standards">
                            <div class="card-body why-card-body px-0">
                                <h3 class="why-text-red mb-3">Compliance with Industry Standards</h3>
                                <p class="card-text">All our signage boards comply with healthcare rules and security protocols.We utilize resistant substances and modern technology to produce submissive and dependable hospital signage.Our LED signs and signboards guarantee transparent observability and durable performance. </p>
                            </div>
                            </div>
                        </div>
                       
                    </div>
                </div>
            </div>

            <div class="why-carousel-controls">
                <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators why-carousel-indicators">
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Comprehensive Range of Medical Signages in Chennai   </h2>
        <p class="card-text text-center">We offer an entire collection of hospital signages in Chennai crafted to fulfill the multiple requirements of healthcare accommodations. Our high-class medical signages guarantee effortless wayfinding, security, and attainability for patients, guests, and workers. With modern designs and substances, our healthcare signs render usefulness and longevity.  .</p>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-7.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Directional and Wayfinding Signs </h2>
                <p class="brand-description">
                    <ul>
                        <li>Assist patients and guests steer large healthcare enterprises with comfort.  .  </li>
                        <li>Traditional signage boards confirm lucid instructions to departments, elevators, and exits.  .  </li>
                        <li>Long-lasting LED signage improves presence in all lighting circumstances. .  </li>
                    </ul>
                </p>
                <h2 class="brand-title">Room Identification Signs</h2>
                <p class="brand-description">
                   
                    <ul>
                        <li>Evidently tagged sign boards for patient rooms, operation theaters, and consultation zones.  .   </li>
                        <li>Comes in several patterns, comprising polished LED signs for a contemporary touch.  .  </li>
                        <li>Promote organization and diminish chaos in congested surroundings.  .</li>
                    </ul>
                </p>
               
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">

        <div class="row align-items-center">

            <div class="col-lg-6 order-2 order-lg-1">
                <h2 class="brand-title">Door Signs </h2>
                <p class="brand-description">
                    
                    <ul>
                        <li>Competent hospital signage for tagging doors such as staff-only sectors or constrained areas.  .   </li>
                        <li>Outlined to suit the beauty of your accommodation.  .  </li>
                        <li>Persistent and readable alternatives, comprising LED signage..</li>
                    </ul>
                </p>
                <h2 class="brand-title">Safety and Warning Signages</h2>
                <p class="brand-description">
                  
                    <ul>
                        <li>Showcase crucial security rules and cautions with high-impact sign boards.  .  </li>
                        <li>Emphasize fire exits, no-entry zones, and risk zones with compliant signage boards.  .  </li>
                        <li> Make sure of compliance with safety rules in healthcare surroundings. </li>
                    </ul>
                
                </p>
            </div>

            <div class="col-lg-6 mb-4 mb-lg-0  order-1 order-lg-2">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-8.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

        </div>
    </div>
</section>
<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
       
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-9.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Informational Signages. </h2>
                <p class="brand-description">
                    <ul>
                        <li>Offer crucial information such as visiting hours, contact numbers, or hygiene regulations.  .  </li>
                        <li>Tailored hospital signages crafted for readability and obtainability.  .    </li>
                        <li>Universal alternatives, from printed boards to digital LED signage..  </li>
                    </ul>
                </p>
              
                <h2 class="brand-title">Restroom Signs. </h2>
                <p class="brand-description">
                    <ul>
                        <li>Gender-centric and attainability-friendly sign boards for restrooms.   </li>
                        <li>Long-lasting substances appropriate for long-rum usage.      </li>
                        <li>Contemporary LED signs that come for improved noticeability.  </li>
                    </ul>
                </p>
              
            </div>
        </div>
    </div>
</section>



<section class="mt-lg-5">
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3" id="gallery-container">
        <h2 class="hero-title">Catalogue</h2>
        
        <!-- First Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-11.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-11.webp')}}" class="img-fluid" alt="Catalogue" style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-12.webp')}}" data-lightbox="catalogue" data-title="Image 2">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-12.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-13.webp')}}" data-lightbox="catalogue" data-title="Image 3">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-13.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-14.webp')}}" data-lightbox="catalogue" data-title="Image 4">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-14.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>
        
        <!-- Second Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-15.webp')}}" data-lightbox="catalogue" data-title="Image 5">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-15.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-16.webp')}}" data-lightbox="catalogue" data-title="Image 6">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-16.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-17.webp')}}" data-lightbox="catalogue" data-title="Image 7">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-17.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/hospital-medical-signages-chennai-18.webp')}}" data-lightbox="catalogue" data-title="Image 8">
                <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-18.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>

    </div>
</section>


<section class="testimonial section ">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">We are very intrigued with the standard of the medical signages offered by this team. The LED signage for our hospital was transparent and simple to read, enhancing steerage for our patients.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. R. Sharma" class="client-img">
                            <div>
                                <div class="client-name">Dr. R. Sharma</div>
                                <div class="client-role">Senior Consultant</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The signage boards that they generated for our clinic are superb. From the hospital signage to the LED signs, everything was outlined properly to suit our requirements.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Priya Mehta" class="client-img">
                            <div>
                                <div class="client-name">Priya Mehta</div>
                                <div class="client-role">Clinic Manager</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">“We were seeking healthcare signs that were both operational and elegantly attractive, and this team rendered much more than our expectations. The LED signs are specifically remarkable and assist in guiding patients efficiently.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. Anand Reddy" class="client-img">
                            <div>
                                <div class="client-name">Dr. Anand Reddy</div>
                                <div class="client-role">Orthopedic Specialist</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The sign board manufacturers were very competent and reactive. The hospital signages were supplied on time, and the sign boards appear incredible. Strongly suggest their services.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. Seema Kapoor" class="client-img">
                            <div>
                                <div class="client-name">Dr. Seema Kapoor</div>
                                <div class="client-role">Pediatrician</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">Their LED signage for our new hospital wing is marvelous. The medical signage makes it simpler for our patients to locate their way around, which is crucial in a congested setting like ours.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Rajesh Iyer" class="client-img">
                            <div>
                                <div class="client-name">Rajesh Iyer</div>
                                <div class="client-role">Operations Manager</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">We are very intrigued with the standard of the medical signages offered by this team. The LED signage for our hospital was transparent and simple to read, enhancing steerage for our patients.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. R. Sharma" class="client-img">
                                        <div>
                                            <div class="client-name">Dr. R. Sharma</div>
                                            <div class="client-role">Senior Consultant</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The signage boards that they generated for our clinic are superb. From the hospital signage to the LED signs, everything was outlined properly to suit our requirements.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Priya Mehta" class="client-img">
                                        <div>
                                            <div class="client-name">Priya Mehta</div>
                                            <div class="client-role">Clinic Manager</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“We were seeking healthcare signs that were both operational and elegantly attractive, and this team rendered much more than our expectations. The LED signs are specifically remarkable and assist in guiding patients efficiently.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. Anand Reddy" class="client-img">
                                        <div>
                                            <div class="client-name">Dr. Anand Reddy</div>
                                <div class="client-role">Orthopedic Specialist</div>

                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“We were seeking healthcare signs that were both operational and elegantly attractive, and this team rendered much more than our expectations. The LED signs are specifically remarkable and assist in guiding patients efficiently. </p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. Anand Reddy" class="client-img">
                                        <div>
                                            <div class="client-name">Dr. Anand Reddy</div>
                                <div class="client-role">Orthopedic Specialist</div>

                                        </div>
                                    </div>
                                </div>              
                        </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The sign board manufacturers were very competent and reactive. The hospital signages were supplied on time, and the sign boards appear incredible. Strongly suggest their services.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Dr. Seema Kapoor" class="client-img">
                                        <div>
                                            <div class="client-name">Dr. Seema Kapoor</div>
                                            <div class="client-role">Pediatrician</div>
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Their LED signage for our new hospital wing is marvelous. The medical signage makes it simpler for our patients to locate their way around, which is crucial in a congested setting like ours.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/hospital-medical-signages-chennai-10.webp')}}" alt="Rajesh Iyer" class="client-img">
                                        <div>
                                            <div class="client-name">Rajesh Iyer</div>
                                            <div class="client-role">Operations Manager</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="testimonial-carousel-controls">
                <button id="prevButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators testimonial-carousel-indicators">
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>



<section class="faq-section">
    <div class="faq-container">
        <h1 class="faq-title">FAQS</h1>

        <div class="faq-item">
            <button class="faq-question">
                What kinds of hospital signage are crucial for healthcare accommodations in Chennai?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Crucial hospital signages in Chennai consist of directional signs, room identification signs, safety and warning signage, restroom signs, and informational signs. These signs confirm patients, guests, and employees can steer the enterprise with comfort and abide by security norms. LED signage can be utilized for improved observability and transparency. </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Can medical signage be personalized to comprise bilingual or ADA-compliant patterns?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Yes, we provide completely tailored medical signages in Chennai. Our patterns can comprise bilingual text and ADA-compliant characteristics, such as red dots and high-contrast colors, guaranteeing attainability for all people, comprising the ones with disabilities.
                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                How do healthcare signs enhance patient experience and steerage?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    Healthcare signs, like LED signage, enhance patient experience by making it simpler to locate departments, rooms, and exits. Evident sign boards assist minimize chaos and stress, offering a streamlined and more effective experience for patients and guests.
                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What substances are utilized for long-lasting and weather-proof hospital signages?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    We utilize high-class substances like aluminum, acrylic, and long-run LED signage for our hospital signages in Chennai. These substances guarantee that the signboards are durable, persistent to weather, and simple to maintain.

                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Are there particular rules for medical signages in Chennai that your designs abide by?

                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Yes, our hospital signages abide by local rules and industry norms. We work closely with authorities to make sure that all our medical signages in Chennai satisfy security, attainability, and observability needs.
                </p>
            </div>
        </div>
       
    </div>
</section>

@endsection