@extends('frontend.layout.appLayout')
@section('content')



<section class="carousel-section">
 

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-1.webp')}}" alt="High-Quality Safety Signages in Chennai">
                <div class="carousel-caption-custom">
                    <h1>High-Quality Safety Signages in Chennai</h1>
                     <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                </div>
            </div>

       

            
        </div>
    </div>
</section>
<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Enhance Your Workplace Safety with Safety Signs at Brand Signages</h2>
        {{-- <p class="card-text text-center">Questions, comments, or suggestions? Simply fill in the form and we’ll be in touch shortly.</p> --}}

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-2.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <p class="brand-description">
                    Workspace security is prime, and Brand Signages is your reliable partner for high-class safety signages in Chennai. We focus on outlining and offering a huge collection of safety signs customized to fulfill your requirements. From construction signs to fire safety signs, our safety signage boards make certain of transparent interaction of risks and protections throughout several industries. Our sign boards are designed to abide by protection norms, providing resistant and durable solutions. Whether you require a caution sign for wet floors, a floor stand for constrained sectors, or safety products to handle contingencies, we’ve all for you. With proficiency in generating safety sign boards and signage boards, we assist organizations maintain a safe atmosphere for workers and guests alike. For industries such as construction, manufacturing, and healthcare, safety signage has an essential role in minimizing dangers. Our collection comprises everything from custom safety equipment to functional fire safety signs for instant clearance. Each signage board is crafted for ultimate observability, confirming lucid communication in crucial times.  
                    Select Brand Signage for dependable safety signs in Chennai that enhance recognition and acceptance. Let us assist you produce a secure workspace with creative safety signages and pragmatic sign boards for all your safety requirements.
                </p>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Why Choose Us for Safety Signages in Chennai?</h2>
            <p class="card-text text-center">When it comes to making sure of protection at work areas, construction sites, or public places, having the appropriate safety signage in Chennai is essential. Our team concentrates on offering standardized safety signs, along with construction signs, fire safety signs, and signboards, customized to satisfy your requirements. Whether you require a safety signage board for a factory or a floor stand caution sign for a commercial place, we render trustworthy and reasonable solutions. Here's why you should select us for your safety sign needs:</p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-3.webp')}}" class="why-card-img-top"
                        alt="Customizable Solutions">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Customizable Solutions</h3>
                        <p class="card-text">We provide entirely made-to-order safety signage to suit your particular needs.From construction signs to fire safety signs, every sign board can be personalized with your branding or particular alerts.Our designs adjust all sizes, colors, and language choices to make certain of ultimate observability and apprehension.  </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-4.webp')}}" class="why-card-img-top"
                        alt="Adherence to Safety Standards">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Adherence to Safety Standards</h3>
                        <p class="card-text">Our safety products abide by local and international safety rules.Each safety sign board is outlined to satisfy industry norms, guaranteeing transparency and efficiency. Be it caution signs or safety equipment markers, our products promote security compliance.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-5.webp')}}" class="why-card-img-top"
                            alt="Affordable and Timely Delivery">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Affordable and Timely Delivery</h3>
                            <p class="card-text">We offer affordable solutions without adjusting to standards.Enjoy punctual delivery of your sign boards, ensuring your projects remain on time.Our effective production method ensures a prompt turnaround for huge orders of safety signage boards.</p>
                        </div>
                    </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-6.webp')}}" class="why-card-img-top"
                        alt="Weather-Resistant Materials">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Weather-Resistant Materials</h3>
                        <p class="card-text">Our safety signage in Chennai is built from resistant, weather-proof substances. Whether for indoor or outdoor usage, our sign boards can bear bad weather circumstances. Perfect for long-run implementations, such as construction signs and floor stand caution signs. </p>
                    </div>
                </div>
        </div>
          
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-7.webp')}}" class="why-card-img-top"
                        alt="Wide Range of Signage Options ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Wide Range of Signage Options </h3>
                        <p class="card-text">Opt from a diversity of safety signage, comprising fire safety signs, traffic signs, and perilous markers.We provide everything from basic caution signs to modern glowing safety signage boards.Our product catalog comprises both normal designs and entirely personalized safety signs. </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-8.webp')}}" class="why-card-img-top"
                        alt="Expert Consultation and Design">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Expert Consultation and Design</h3>
                        <p class="card-text">Get support from our expert professionals for outlining the ideal safety signage. We utilize modern technology to generate transparent and efficient safety signage boards.Our team confirms that each signboard conveys the planned message efficiently.</p>
                    </div>
                </div>
            </div>
        </div>

        <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-3.webp')}}" class="why-card-img-top"
                                    alt="Customizable Solutions">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customizable Solutions</h3>
                                    <p class="card-text">We provide entirely made-to-order safety signage to suit your particular needs.From construction signs to fire safety signs, every sign board can be personalized with your branding or particular alerts.Our designs adjust all sizes, colors, and language choices to make certain of ultimate observability and apprehension.  </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-4.webp')}}" class="why-card-img-top"
                                    alt="Adherence to Safety Standards">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Adherence to Safety Standards</h3>
                                    <p class="card-text">Our safety products abide by local and international safety rules.Each safety sign board is outlined to satisfy industry norms, guaranteeing transparency and efficiency. Be it caution signs or safety equipment markers, our products promote security compliance.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Aesthetic Appeal">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Affordable and Timely Delivery</h3>
                                    <p class="card-text">
                                        We offer affordable solutions without adjusting to standards.Enjoy punctual delivery of your sign boards, ensuring your projects remain on time.Our effective production method ensures a prompt turnaround for huge orders of safety signage boards.

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-6.webp')}}" class="why-card-img-top"
                                alt="Weather-Resistant Materials">
                            <div class="card-body why-card-body px-0">
                                <h3 class="why-text-red mb-3">Weather-Resistant Materials</h3>
                                <p class="card-text">Our safety signage in Chennai is built from resistant, weather-proof substances. Whether for indoor or outdoor usage, our sign boards can bear bad weather circumstances. Perfect for long-run implementations, such as construction signs and floor stand caution signs. </p>
                            </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-7.webp')}}" class="why-card-img-top"
                                    alt="Wide Range of Signage Options ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Wide Range of Signage Options </h3>
                                    <p class="card-text">Opt from a diversity of safety signage, comprising fire safety signs, traffic signs, and perilous markers.We provide everything from basic caution signs to modern glowing safety signage boards.Our product catalog comprises both normal designs and entirely personalized safety signs. </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-8.webp')}}" class="why-card-img-top"
                                    alt="Expert Consultation and Design">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Expert Consultation and Design</h3>
                                    <p class="card-text">Get support from our expert professionals for outlining the ideal safety signage. We utilize modern technology to generate transparent and efficient safety signage boards.Our team confirms that each signboard conveys the planned message efficiently.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="why-carousel-controls">
                <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators why-carousel-indicators">
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">High-Quality Construction Signs for Maximum Safety   </h2>
        <p class="card-text text-center">Safety is a primary concern at construction plots, and having the appropriate safety signage in Chennai is critical to forbid accidents. Safety signs in Chennai render lucid notifications and guidelines to employees and guests, making certain of submission with safety protocols. Whether it’s construction signs or fire safety signs, a well-positioned signboard can make a considerable change in reducing dangers. Below are some main aspects and advantages of standardized safety signage boards for construction plots:</p>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-9.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Durable Materials for Longevity </h2>
                <p class="brand-description">
                    High-claas safety signage is formed from long-lasting substances like metal or weather-proof plastic to bear hard construction atmospheres.
                </p>
                <h2 class="brand-title">Clear and Visible Design</h2>
                <p class="brand-description">
                    
                    Safety sign boards are crafted with highlighted colors and readable text, making sure that they are noticeable from remote, even in dim light.
                </p>
                <h2 class="brand-title">Customizable Options</h2>
                <p class="brand-description">
                    
                    Customized signboards can fulfill partiy site needs, including caution signsl for perilous sectors or intructiinal safety signs for emergency exits.
                </p>
                <h2 class="brand-title">Compliance with Safety Standards</h2>
                <p class="brand-description">
                    
                    Confirm that your site abides by legal safety rules by installing the suitable safety signage boards for staff's safety.
                </p>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">

        <div class="row align-items-center">

            <div class="col-lg-6 order-2 order-lg-1">
                <h2 class="brand-title">Multilingual Signs for Diverse Teams</h2>
                <p class="brand-description">
                    
                    Signage boards with bilingual text guarantee that all team members, irrespective of language, comprehend the notifications.
                </p>
                <h2 class="brand-title">Variety of Sign Types</h2>
                <p class="brand-description">
                  
                    Alternatives include floor stands, wall-bracket safety products, and dropping safety sign boards to fit several needs.
                </p>
                <h2 class="brand-title">Enhanced Fire Safety</h2>

                <p class="brand-description">
                  
                    Specific fire safety signs denote fire extinguishers, alarms, and exits, guaranteeing an immediate reaction during contingencies.
                </p>
                <h2 class="brand-title">Promotes a Safer Workplace</h2>

                <p class="brand-description">
                  
                    Deliberately positioned safety equipment and safety signage minimize accidents, promoting all-round protection and usefulness. 
                </p>
            </div>

            <div class="col-lg-6 mb-4 mb-lg-0  order-1 order-lg-2">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-10.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

        </div>
    </div>
</section>



<section class="why-bg-light-pink py-5" style="background-color: #fff;">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Our Range of Safety Signs in Chennai </h2>
            <p class="card-text text-center">When it comes to guaranteeing work area security and submission, safety signages in Chennai play an essential part. From industrial sectors to construction sites, the appropriate safety signage board gives simple instructions, alerts, and support to retain a safe atmosphere. We provide a huge collection of safety sign boards, sign boards, and safety equipment that serve multiple needs, confirming that each sector is furnished with trustworthy safety products. With alternatives for personalization and submission with security norms, our safety signage solutions are ideal for all industries and assist in producing secure, more arranged places. </p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-11.webp')}}" class="why-card-img-top"
                        alt="Industrial Safety Signages">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Industrial Safety Signages</h3>
                        <p class="card-text">
                          <ul>
                            <li>Long-lasting signage boards crafted for factories and manufacturing sectors.   </li>
                            <li>Comprises caution signs for machinery, dangerous substances, and constrained sectors.  </li>
                            <li>Abidance with security protocols to reduce workspace mishappenings.</li>
                          </ul>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-12.webp')}}" class="why-card-img-top"
                        alt="Construction ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Construction Safety Signs </h3>
                        <p class="card-text">
                            <ul>
                                <li>Vital construction signs for building plots in Chennai.      </li>
                                <li>Encircles perilous sectors, safety gear needs, and limited zones.  </li>
                                <li>Weather-proof sign boards for durable usage.</li>
                              </ul>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-13.webp')}}" class="why-card-img-top"
                        alt="Fire Safety Signs">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Fire Safety Signs</h3>
                        <p class="card-text">
                            <ul>
                                <li>High-noticeability fire safety signs denoting extinguishers, alarms, and emergency rules.   </li>
                                <li>Luminous safety sign boards for observability during a power interruption.  </li>
                                <li>Luminous safety sign boards for observability during a power interruption.  </li>
                              </ul>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-23.webp')}}" class="why-card-img-top"
                        alt="Customized Safety Signage">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Customized Safety Signage</h3>
                        <p class="card-text">
                            <ul>
                                <li>Customized safety signages in Chennai to fulfill exceptional business requirements.   </li>
                                <li>Select from various substances, sizes, and designs.   </li>
                                <li>Ideal for branding while confirming safety submission.   </li>
                              </ul>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-24.webp')}}" class="why-card-img-top"
                        alt="Emergency Exit Signs">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Emergency Exit Signs</h3>
                        <p class="card-text">
                            <ul>
                                <li>Translucent and lively emergency exit signage boards for immediate clearance.    </li>
                                <li>Submissive to domestic rules for public and private places.  </li>
                                <li>Comprises floor stand alternatives for short-span setups.</li>
                              </ul>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-25.webp')}}" class="why-card-img-top"
                        alt="Danger and Warning Signs">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Danger and Warning Signs</h3>
                        <p class="card-text">
                          <ul>
                            <li>High-influence caution signs to warn against electrical perils, slippery floors, and other dangers.   </li>
                            <li>Engraved signs generate a superior, distinct charm with bright textures.   </li>
                            <li>Resistant substances guarantee dependability in all surroundings.</li>
                          </ul>
                        </p>
                        </p>
                    </div>
                </div>
            </div>
          
           
            
        </div>

        <div id="signageCarouselNew" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-11.webp')}}" class="why-card-img-top"
                                    alt="Industrial Safety Signages">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Industrial Safety Signages</h3>
                                    <p class="card-text">
                                        <ul>
                                          <li>Long-lasting signage boards crafted for factories and manufacturing sectors.   </li>
                                          <li>Comprises caution signs for machinery, dangerous substances, and constrained sectors.  </li>
                                          <li>Abidance with security protocols to reduce workspace mishappenings.</li>
                                        </ul>
                                      </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-12.webp')}}" class="why-card-img-top"
                                    alt="Safety Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Construction </h3>

                                    <p class="card-text">
                                        <ul>
                                            <li>Vital construction signs for building plots in Chennai.      </li>
                                            <li>Encircles perilous sectors, safety gear needs, and limited zones.  </li>
                                            <li>Weather-proof sign boards for durable usage.</li>
                                          </ul>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-13.webp')}}" class="why-card-img-top"
                                    alt="Fire Safety Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Fire Safety Signs</h3>
                                    <p class="card-text">
                                        <ul>
                                            <li>High-noticeability fire safety signs denoting extinguishers, alarms, and emergency rules.   </li>
                                            <li>Luminous safety sign boards for observability during a power interruption.  </li>
                                            <li>Luminous safety sign boards for observability during a power interruption.  </li>
                                          </ul>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-23.webp')}}" class="why-card-img-top"
                                    alt="Customized Safety Signage">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customized Safety Signage</h3>
                                    <p class="card-text">
                                        <ul>
                                            <li>Customized safety signages in Chennai to fulfill exceptional business requirements.   </li>
                                            <li>Select from various substances, sizes, and designs.   </li>
                                            <li>Ideal for branding while confirming safety submission.   </li>
                                          </ul>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-24.webp')}}" class="why-card-img-top"
                                    alt="Emergency Exit Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Emergency Exit Signs</h3>
                                    <p class="card-text">
                                        <ul>
                                            <li>Translucent and lively emergency exit signage boards for immediate clearance.    </li>
                                            <li>Submissive to domestic rules for public and private places.  </li>
                                            <li>Comprises floor stand alternatives for short-span setups.</li>
                                          </ul>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-25.webp')}}" class="why-card-img-top"
                                    alt="Danger and Warning Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Danger and Warning Signs</h3>
                                    <p class="card-text">
                                        <ul>
                                          <li>High-influence caution signs to warn against electrical perils, slippery floors, and other dangers.   </li>
                                          <li>Engraved signs generate a superior, distinct charm with bright textures.   </li>
                                          <li>Resistant substances guarantee dependability in all surroundings.</li>
                                        </ul>
                                      </p>
                                </div>
                            </div>
                        </div>
                       
                    </div>
                </div>
               
            </div>

            <div class="why-carousel-controls">
                <button id="prevButtonNew" class="why-carousel-control" type="button" data-bs-target="#signageCarouselNew"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButtonNew" class="why-carousel-control" type="button" data-bs-target="#signageCarouselNew"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
                
            </div>

            <div class="carousel-indicators why-carousel-indicators" style="margin-bottom: -0.8rem;">
                <button type="button" data-bs-target="#signageCarouselNew" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarouselNew" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
               
            </div>
        </div>
    </div>
</section>
<section class="mt-lg-5">
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3" id="gallery-container">
        <h2 class="hero-title">Catalogue</h2>
        
        <!-- First Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-15.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-15.webp')}}" class="img-fluid" alt="Catalogue" style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-16.webp')}}" data-lightbox="catalogue" data-title="Image 2">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-16.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-17.webp')}}" data-lightbox="catalogue" data-title="Image 3">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-17.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-18.webp')}}" data-lightbox="catalogue" data-title="Image 4">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-18.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>
        
        <!-- Second Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-19.webp')}}" data-lightbox="catalogue" data-title="Image 5">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-19.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-20.webp')}}" data-lightbox="catalogue" data-title="Image 6">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-20.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-21.webp')}}" data-lightbox="catalogue" data-title="Image 7">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-21.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-22.webp')}}" data-lightbox="catalogue" data-title="Image 8">
                <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-22.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>

    </div>
</section>

<section class="testimonial section ">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The class of their safety signage in Chennai is top-class. The safety signsl are transparent and resistant, making our construction site much secure.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-28.webp')}}" alt="Ramesh Kumar" class="client-img">
                            <div>
                                <div class="client-name">Ramesh Kumar</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">We placed the order for a personalized construction signs, and the service was unique. The signage boards are strong and weather-proof, perfect for our outdoor projects.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-30.webp')}}" alt="Priya Sharma" class="client-img">
                            <div>
                                <div class="client-name">Priya Sharma</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">Their fire safety signs have made a substantial alteration in ensuring contingency preparedness at our site. The safety sign boards are well-shaped and easily readable.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-31.webp')}}" alt="Arvind Menon" class="client-img">
                            <div>
                                <div class="client-name">Arvind Menon</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The diversity of safety products that they provide is intriguing. From floor stands to wall-bracket caution signs, they have all you require for a shielded workplace.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-32.webp')}}" alt="Neha Verma" class="client-img">
                            <div>
                                <div class="client-name">Neha Verma</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">We are very content with their sign boards and safety signage boards. The team acknowledged our needs correctly and rendered high-class products on time.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-33.webp')}}" alt="Karthik Rao" class="client-img">
                            <div>
                                <div class="client-name">Karthik Rao</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The class of their safety signage in Chennai is top-class. The safety signsl are transparent and resistant, making our construction site much secure.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-28.webp')}}" alt="Ramesh Kumar" class="client-img">
                                        <div>
                                            <div class="client-name">Ramesh Kumar</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">We placed the order for a personalized construction signs, and the service was unique. The signage boards are strong and weather-proof, perfect for our outdoor projects.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-30.webp')}}" alt="Priya Sharma" class="client-img">
                                        <div>
                                            <div class="client-name">Priya Sharma</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Their fire safety signs have made a substantial alteration in ensuring contingency preparedness at our site. The safety sign boards are well-shaped and easily readable.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-31.webp')}}" alt="Arvind Menon" class="client-img">
                                        <div>
                                            <div class="client-name">Arvind Menon</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Their fire safety signs have made a substantial alteration in ensuring contingency preparedness at our site. The safety sign boards are well-shaped and easily readable.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-31.webp')}}" alt="Arvind Menon" class="client-img">
                                        <div>
                                            <div class="client-name">Arvind Menon</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The diversity of safety products that they provide is intriguing. From floor stands to wall-bracket caution signs, they have all you require for a shielded workplace.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-32.webp')}}" alt="Neha Verma" class="client-img">
                                        <div>
                                            <div class="client-name">Neha Verma</div>
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">We are very content with their sign boards and safety signage boards. The team acknowledged our needs correctly and rendered high-class products on time.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-safety-signages-in-chennai-33.webp')}}" alt="Karthik Rao" class="client-img">
                                        <div>
                                            <div class="client-name">Karthik Rao</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="testimonial-carousel-controls">
                <button id="prevButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators testimonial-carousel-indicators">
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>



<section class="faq-section">
    <div class="faq-container">
        <h1 class="faq-title">FAQS</h1>

        <div class="faq-item">
            <button class="faq-question">
                What are the major advantages of utilizing safety signage in Chennai?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Safety signage in Chennai is crucial for retaining workplace security. They offer clear directions, alerts, and reminders, minimizing the probabilities of accidents. These safety signs enhance realization among employees and guests, ensuring submission with protection rules. Properly positioned safety sign boards can promote efficiency by alleviating perils and producing a safe atmosphere.</p>
            </div>
        </div>


        <div class="faq-item">
            <button class="faq-question">
                How do construction safety signs assist in averting workplace mishappenings?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    Construction signs cater as visual warnings, determining risks like falling objects, slippery grounds, or constrained zones. These caution signs inform staffs to wear good safety equipment or comply with particular rules. By providing clear and noticeable messaging, safety signage boards assist in forbiding wounds and retain structure at construction plots.

                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What kinds of fire safety signs are indispensable for submission in Chennai? 

                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Indispensable fire safety signs in Chennai comprise emergency exit markers, fire extinguisher places, and alarm point pointers. These safety signs must abide by domestic safety protocols and be easily observable in emergencies. Signage boards fire evacuation and assembly points are also critical for efficient clearance planning.
                </p>
            </div>
        </div>
        
        <div class="faq-item">
            <button class="faq-question">
                Can I get tailored safety signs for particular needs in my industry?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    Yes, tailored safety signages are attainable for several industries. From exceptional sign boards to customized floor stands, you can outline signage that suits your particular safety requirements. This guarantees ultimate applicability and efficiency in your workspace.
                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                How resistant are the substances utilized for outdoor safety signage?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Outdoor safety signage is built utilizing resistant substances like metal, aluminum, or weatherproof plastic. These sign boards bear rough conditions, ensuring durable observability and dependability.  
                </p>
            </div>
        </div>
       
    </div>
</section>

@endsection