@extends('frontend.layout.appLayout')
@section('content')



<section class="carousel-section">
 

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-1.webp')}}" alt="High-Quality Safety Signages in Chennai">
                <div class="carousel-caption-custom">
                    <h1>High-Quality Safety Signages in Chennai</h1>
                     <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                </div>
            </div>

       

            
        </div>
    </div>
</section>
<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Upgrade Your Facility with Restroom Signs in Chennai</h2>
        {{-- <p class="card-text text-center">Questions, comments, or suggestions? Simply fill in the form and we’ll be in touch shortly.</p> --}}

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-2.webp')}}" alt="Prohibitory Signages" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <p class="brand-description">
                    Make sure that your accommodation is well-structured and reachable with standardized restroom signs in Chennai. Transparent and resistant toilet sign boards assist guests in seamlessly finding the men’s restroom, ladies’ toilet, and unisex restroom signs. Whether you require office restroom signs or accessible restroom pointers, we offer a huge collection of toilet signage alternatives to fit your requirements. Our sign boards are built from substances like stainless steel and aluminum toilet signs, providing long-term resistance and a sophisticated appearance. You can select from classy toilet sign boards or personalize them to suit your facility's pattern. For family-friendly places, our family room signs comprise a changing table emblem to assist parents.  
                </p>
                <p class="brand-description">
                    We also provide white sticker signs for easier installations or short-term requirements. Whether you require to label particular facilities, like the ladies toilet or a custom washroom sign, our aluminium toilet signage makes certain of lucid determination for all guests. By updating with competent restroom signs, you enhance your facility’s operationality and improve a better experience for all.
                </p>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Why Choose Us for Restroom Signs in Chennai?</h2>
            <p class="card-text text-center">We are your reliable provider of restroom signs in Chennai, providing an array of alternatives for each facility. Whether you require unisex restroom signs, office restroom signs, or accessible restroom markers, we have the perfect sign board for your requirements. Here's why you should opt for us:  </p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-3.webp')}}" class="why-card-img-top"
                        alt="Wide Range of Designs  ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Wide Range of Designs  </h3>
                        <p class="card-text">We provide a huge selection of toilet sign boards to fit all kinds of facilities. From men’s restroom and ladies’ toilet signs to contemporary unisex restroom signs, our selection confirms that your washroom places are evidently labeled for all. Whether you need a family room or specific changing table signs, we have all alternatives available for simple steerage. We also offer a diversity of design patterns to suit your decor. </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-4.webp')}}" class="why-card-img-top"
                        alt="Customization Options ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Customization Options </h3>
                        <p class="card-text">We offer custom restroom signs that permit you to customize the design, size, and signs to satisfy the exceptional requirements of your facility. Whether it's attaching a changing table symbol for family-friendly places or personalizing your washroom sign, we can make it take place. Our team labors attentively with you to make realities out of your vision, guaranteeing your signage is operational and visually attractive. </p>
                    </div>
                </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-5.webp')}}" class="why-card-img-top"
                            alt="High-Quality Materials">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">High-Quality Materials</h3>
                            <p class="card-text">Our toilet signage is designed from long-lasting substances like stainless steel and aluminum toilet signs. These standardized substances confirm that your toilet sign boards repel wear and tear, making them ideal for both indoor and outdoor usage.</p>
                        </div>
                    </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-6.webp')}}" class="why-card-img-top"
                        alt="Long-Lasting Durability ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Long-Lasting Durability </h3>
                        <p class="card-text">Outlined to persist, our signs provide extraordinary resistance to weather and destruction. With our aluminium toilet sign alternatives and white sticker options, you get symbols that maintain their simplicity and look with time, even in congested zones.  
                        </p>
                    </div>
                </div>
        </div>
          
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-7.webp')}}" class="why-card-img-top"
                        alt="Affordable Pricing  ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Affordable Pricing  </h3>
                        <p class="card-text"> We consider providing affordable restroom signs without adjusting on class. Our combative pricing guarantees you get the best worth for your capital while still getting top-class sign boards that satisfy all your signage requirements. </p>
                    </div>
                </div>
            </div>
           
        </div>

        <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-3.webp')}}" class="why-card-img-top"
                                    alt="Wide Range of Designs  ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Wide Range of Designs  </h3>
                                    <p class="card-text">We provide a huge selection of toilet sign boards to fit all kinds of facilities. From men’s restroom and ladies’ toilet signs to contemporary unisex restroom signs, our selection confirms that your washroom places are evidently labeled for all. Whether you need a family room or specific changing table signs, we have all alternatives available for simple steerage. We also offer a diversity of design patterns to suit your decor.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-4.webp')}}" class="why-card-img-top"
                                    alt="Customization Options ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customization Options </h3>
                                    <p class="card-text">We offer custom restroom signs that permit you to customize the design, size, and signs to satisfy the exceptional requirements of your facility. Whether it's attaching a changing table symbol for family-friendly places or personalizing your washroom sign, we can make it take place. Our team labors attentively with you to make realities out of your vision, guaranteeing your signage is operational and visually attractive. </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Aesthetic Appeal">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">High-Quality Materials</h3>
                                    <p class="card-text">
                                        Our toilet signage is designed from long-lasting substances like stainless steel and aluminum toilet signs. These standardized substances confirm that your toilet sign boards repel wear and tear, making them ideal for both indoor and outdoor usage.

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-5.webp')}}" class="why-card-img-top"
                                    alt="Aesthetic Appeal">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">High-Quality Materials</h3>
                                    <p class="card-text">
                                        Our toilet signage is designed from long-lasting substances like stainless steel and aluminum toilet signs. These standardized substances confirm that your toilet sign boards repel wear and tear, making them ideal for both indoor and outdoor usage.

                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-6.webp')}}" class="why-card-img-top"
                                alt="Long-Lasting Durability ">
                            <div class="card-body why-card-body px-0">
                                <h3 class="why-text-red mb-3">Long-Lasting Durability </h3>
                                <p class="card-text">Outlined to persist, our signs provide extraordinary resistance to weather and destruction. With our aluminium toilet sign alternatives and white sticker options, you get symbols that maintain their simplicity and look with time, even in congested zones.                                  </p>
                            </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-7.webp')}}" class="why-card-img-top"
                                    alt="Affordable Pricing  ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Affordable Pricing  </h3>
                                    <p class="card-text"> We consider providing affordable restroom signs without adjusting on class. Our combative pricing guarantees you get the best worth for your capital while still getting top-class sign boards that satisfy all your signage requirements. </p>
                                </div>
                            </div>
                        </div>
                      
                    </div>
                </div>
            </div>

            <div class="why-carousel-controls">
                <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators why-carousel-indicators">
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5" style="background-color: #fff;">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Our Range of Restroom Signs in Chennai </h2>
            <p class="card-text text-center">We provide a huge collection of restroom signs in Chennai to satisfy the requirements of each facility. Whether you're seeking unisex restroom signs, office restroom signs, or accessible restroom markers, we have the ideal sign board for you. Our signs are outlined for simplicity, longevity, and comfort of installation. Whether it’s a congested commercial place or a small office, our toilet signage ensures an effortless usefulness. Here's a look at our collection of toilet signage alternatives:</p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-8.webp')}}" class="why-card-img-top"
                        alt="Standard Restroom Signs">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Standard Restroom Signs</h3>
                        <p class="card-text">
                            We offer transparent and simple toilet sign boards for men's restrooms and ladies’ toilets. These toilet signs are crafted for easy noticeability and come in several substances like stainless steel and aluminium toilet signs.  
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-9.webp')}}" class="Unisex Restroom Signs"
                        alt="Construction ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Unisex Restroom Signs  </h3>
                        <p class="card-text">
                            Our unisex restroom signs are ideal for places that serve all genders. Obtainable in polished designs and high-class substances, these sign boards are simple to read and perfect for advanced facilities.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-10.webp')}}" class="Accessible Restroom Signs  "
                        alt="Accessible Restroom Signs  ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Accessible Restroom Signs  </h3>
                        <p class="card-text">
                            Make certain of extensiveness with our accessible restroom signs. These toilet signage alternatives are outlined to fulfill ADA (Americans with Disabilities Act) norms, guaranteeing simple access for all.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-11.webp')}}" class="Custom Restroom Signs "
                        alt="Custom Restroom Signs ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Custom Restroom Signs </h3>
                        <p class="card-text">
                             If you require something exceptional, our custom restroom signs can be personalized to your particular requirements. From family room and changing table signs to specific washroom signs, we provide a variety of traditional designs.
                        </p>
                    </div>
                </div>
            </div>
         
            
          
           
            
        </div>

        <div id="signageCarouselNew" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-8.webp')}}" class="why-card-img-top"
                                    alt="Standard Restroom Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Standard Restroom Signs</h3>
                                    <p class="card-text">
                                        We offer transparent and simple toilet sign boards for men's restrooms and ladies’ toilets. These toilet signs are crafted for easy noticeability and come in several substances like stainless steel and aluminium toilet signs.  
                                      </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-9.webp')}}" class="why-card-img-top"
                                    alt="Unisex Restroom Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Unisex Restroom Signs </h3>

                                    <p class="card-text">
                                        Our unisex restroom signs are ideal for places that serve all genders. Obtainable in polished designs and high-class substances, these sign boards are simple to read and perfect for advanced facilities.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-10.webp')}}" class="why-card-img-top"
                                    alt="Accessible Restroom Signs  ">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Accessible Restroom Signs  </h3>
                                        <p class="card-text">
                                            Make certain of extensiveness with our accessible restroom signs. These toilet signage alternatives are outlined to fulfill ADA (Americans with Disabilities Act) norms, guaranteeing simple access for all.
                                        </p>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-9.webp')}}" class="why-card-img-top"
                                    alt="Unisex Restroom Signs">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Unisex Restroom Signs </h3>

                                    <p class="card-text">
                                        Our unisex restroom signs are ideal for places that serve all genders. Obtainable in polished designs and high-class substances, these sign boards are simple to read and perfect for advanced facilities.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-10.webp')}}" class="why-card-img-top"
                                    alt="Accessible Restroom Signs  ">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Accessible Restroom Signs  </h3>
                                        <p class="card-text">
                                            Make certain of extensiveness with our accessible restroom signs. These toilet signage alternatives are outlined to fulfill ADA (Americans with Disabilities Act) norms, guaranteeing simple access for all.
                                        </p>
                                    </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-11.webp')}}" class="why-card-img-top"
                                    alt="Custom Restroom Signs ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Custom Restroom Signs </h3>
                                    <p class="card-text">
                                         If you require something exceptional, our custom restroom signs can be personalized to your particular requirements. From family room and changing table signs to specific washroom signs, we provide a variety of traditional designs.
                                    </p>
                                </div>
                            </div>
                        </div>
                       
                    </div>
                </div>
               
            </div>

            <div class="why-carousel-controls">
                <button id="prevButtonNew" class="why-carousel-control" type="button" data-bs-target="#signageCarouselNew"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButtonNew" class="why-carousel-control" type="button" data-bs-target="#signageCarouselNew"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
                
            </div>

            <div class="carousel-indicators why-carousel-indicators" style="margin-bottom: -0.8rem;">
                <button type="button" data-bs-target="#signageCarouselNew" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarouselNew" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
               
            </div>
        </div>
    </div>
</section>
<section class="mt-lg-5">
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3" id="gallery-container">
        <h2 class="hero-title">Catalogue</h2>
        
        <!-- First Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-13.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-13.webp')}}" class="img-fluid" alt="Catalogue" style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-14.webp')}}" data-lightbox="catalogue" data-title="Image 2">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-14.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-15.webp')}}" data-lightbox="catalogue" data-title="Image 3">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-15.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-16.webp')}}" data-lightbox="catalogue" data-title="Image 4">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-16.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>
        
        <!-- Second Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-17.webp')}}" data-lightbox="catalogue" data-title="Image 5">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-17.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-18.webp')}}" data-lightbox="catalogue" data-title="Image 6">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-18.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-19.webp')}}" data-lightbox="catalogue" data-title="Image 7">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-19.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-20.webp')}}" data-lightbox="catalogue" data-title="Image 8">
                <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-20.webp')}}" class="img-fluid" alt="Catalogue"  style="width: 100%;">
                </a>
            </div>
        </div>

    </div>
</section>

<section class="testimonial section ">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">These restroom signs in Chennai are perfectly what we require for our office. The unisex restroom signs are transparent, and the aluminum toilet signs appear great.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Priya S" class="client-img">
                            <div>
                                <div class="client-name">Priya S</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">I placed the order for a traditional toilet sign board for our accommodation, and the design was ideal. The stainless steel coating looks contemporary, and the toilet signage is highly resistant.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Ramesh K" class="client-img">
                            <div>
                                <div class="client-name">Ramesh K</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The accessible restroom signs we purchased are extraordinary. They are simple to read, and the white sticker alternative was perfect for our budget. Highly suggested!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Sandeep M" class="client-img">
                            <div>
                                <div class="client-name">Sandeep M</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">We required simple men's restrooms and ladies’ toilet symbols for our restaurant. These toilet sign boards are robust and simple to install. Very glad with the purchase.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Anjali R" class="client-img">
                            <div>
                                <div class="client-name">Anjali R</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">We are very content with their sign boards and safety signage boards. The team acknowledged our needs correctly and rendered high-class products on time.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Harish P" class="client-img">
                            <div>
                                <div class="client-name">Harish P</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">These restroom signs in Chennai are perfectly what we require for our office. The unisex restroom signs are transparent, and the aluminum toilet signs appear great.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Priya S" class="client-img">
                                        <div>
                                            <div class="client-name">Priya S</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">I placed the order for a traditional toilet sign board for our accommodation, and the design was ideal. The stainless steel coating looks contemporary, and the toilet signage is highly resistant.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Ramesh K" class="client-img">
                                        <div>
                                            <div class="client-name">Ramesh K</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The accessible restroom signs we purchased are extraordinary. They are simple to read, and the white sticker alternative was perfect for our budget. Highly suggested!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Sandeep M" class="client-img">
                                        <div>
                                            <div class="client-name">Sandeep M</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The accessible restroom signs we purchased are extraordinary. They are simple to read, and the white sticker alternative was perfect for our budget. Highly suggested!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Sandeep M" class="client-img">
                                        <div>
                                            <div class="client-name">Sandeep M</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">We required simple men's restrooms and ladies’ toilet symbols for our restaurant. These toilet sign boards are robust and simple to install. Very glad with the purchase.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Anjali R" class="client-img">
                                        <div>
                                            <div class="client-name">Anjali R</div>
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Our new office now has washroom signs that all can simply see. The changing table sign and family room signs are an ideal sum to our place.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        <img src="{{asset('frontend/Images/new/high-quality-restroom-signs-in-chennai-12.webp')}}" alt="Harish P" class="client-img">
                                        <div>
                                            <div class="client-name">Harish P</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="testimonial-carousel-controls">
                <button id="prevButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators testimonial-carousel-indicators">
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>



<section class="faq-section">
    <div class="faq-container">
        <h1 class="faq-title">FAQS</h1>

        <div class="faq-item">
            <button class="faq-question">
                What kinds of restroom signs are attainable for public and private places in Chennai?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>We provide a huge range of restroom signs in Chennai for both public and private places. Whether you require men’ restroom, ladies’ toilet, or unisex restroom signs, we deliver a diversity of alternatives, comprising toilet sign boards, washroom signs, and accessible restroom indicators. Our signs are available in several substances like stainless steel and aluminium toilet signs for durable usage.</p>
            </div>
        </div>


        <div class="faq-item">
            <button class="faq-question">
                Can I personalize unisex restroom signs to suit my facility’s branding?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    Yes, we provide personalization for unisex restroom signs. You can customize the design, color, size, and symbols to match your facility’s branding. Whether it's attaching a family room symbol or selecting the substance for your toilet signage, we make sure that your signage suits your facility’s elegance and usefulness.

                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What substances are utilized to make sure of resistance and persistence of restroom signs?  
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>We utilize high-class substances like stainless steel and aluminum toilet signs to confirm the longevity of our toilet sign boards. These substances are persistent in wear, weather, and destruction, making them ideal for both indoor and outdoor utility. You can also opt for white sticker alternatives for a reasonable yet long-lasting solution.
                </p>
            </div>
        </div>
        
        <div class="faq-item">
            <button class="faq-question">
                Are your restroom signs submissive to accessibility norms, such as ADA instructions?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>
                    Yes, our accessible restroom signs abide by accessibility norms, including ADA (Americans with Disabilities Act) instructions. We confirm that our signs are simple to read and follow the needed symbols to deliver an extensive approach to all.
                </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                How fast can I get office restroom signs supplied and installed in Chennai?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>We provide quick supply and installation services for office restroom signs in Chennai. Based on the order size and personalization needs, we aim to render and install your toilet sign boards in a punctual way, guaranteeing the least interruption to your functions.
                </p>
            </div>
        </div>
       
    </div>
</section>

@endsection