@extends('frontend.layout.appLayout')
@section('content')
<section class="carousel-section">
    <div id="imageCarousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#imageCarousel" data-bs-slide-to="0" class="active"
                aria-current="true" aria-label="Slide 1"></button>
            <button type="button" data-bs-target="#imageCarousel" data-bs-slide-to="1"
                aria-label="Slide 2"></button>
            
        </div>

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-1.webp')}}" alt="Digital Signage Manufacturers in Mumbai">
                <div class="carousel-caption-custom">
                    <h1>Best Digital Signages Manufacturer in Mumbai</h1>
                     <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                </div>
            </div>

            <div class="carousel-item">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-2.webp')}}" alt="Digital Signage Manufacturers in Mumbai">
                <div class="carousel-caption-custom">
                    <h2>Digital Signages Display Manufacturers Mumbai</h2>
                     <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                </div>
            </div>

            
        </div>
    </div>
</section>


<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Your Trusted Partner for Digital Signages in Mumbai
        </h2>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-3.webp')}}" alt="Digital Signage Manufacturers in Mumbai" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <p class="brand-description">
                    Digital signages are designed to grab attention with visually appealing displays. Compared to other signages it showcases advertising and promotional information more effectively. High-resolution screens and real-time information display make it the most prominent option for top businesses. Retail spaces, restaurants, and public spaces can leverage the benefits by highlighting offers, new arrivals, and more. 

                                </p>
                <p class="brand-description">
                    We are a pioneering Digital signage manufacturer, providing inventive and personalized digital signage solutions for organizations in Mumbai. Our innovative digital signage displays are outlined to improve your brand observability and customer engrossment. From glossy digital standee displays to communicative digital display boards, we offer flexible signage solutions as a premier digital signage vendor. Whether you need a high-class outdoor LED display or an easy-to-operate touchscreen kiosk, we supply dependable and competent display solutions.  

                </p>
                <p class="brand-description">
                    Our collection comprises vibrant video walls, flat panels, and modern advertising displays that allure your viewers. With made-to-order alternatives, our digital signage suits effortlessly into any atmosphere, from retail outlets and offices to public places.  We are the top digital signage manufacturers in Mumbai for creative and influential signage solutions. 
    
                </p>
            </div>
        </div>
    </div>
</section>

<section class="why-bg-light-pink py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Why Choose Us for Digital Signages</h2>
            <p class="card-text text-center">Opt for Brand Signage for dependable and creative digital signage solutions that entitle your organization to be distinct. Contact us soon for customized digital signage displays that reform your brand's visual attraction.</p>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-4.webp')}}" class="why-card-img-top"
                        alt="Customizable Designs    ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Customizable Designs    </h3>
                        <p class="card-text">We concentrate on generating customized digital signage displays to fit your particular requirements. Whether it's a polished digital standee display, an advertising display, or a dynamic video wall, we make sure that your signage is exceptional, influential, and lined up with your brand’s recognition.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-5.webp')}}" class="why-card-img-top"
                        alt="Cutting-Edge Technology ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Cutting-Edge Technology </h3>
                        <p class="card-text">As a reliable Digital signage manufacturer in Mumbai, we combine modern technology into each product. From touchscreen kiosks to vibrant LED displays and interactive flat panels, our solutions are outlined to allure viewers and improve your communication schemes.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-6.webp')}}" class="why-card-img-top"
                            alt=" Durable and Reliable Products">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3"> Durable and Reliable Products</h3>
                            <p class="card-text">Our digital signage products are made to persist. Utilizing superior substances and modern manufacturing policies, we ensure dependability and resistance in indoor and outdoor LED display atmospheres, even under difficult circumstances. </p>
                        </div>
                    </div>
            </div>
            
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-7.webp')}}" class="why-card-img-top"
                        alt="Comprehensive Services ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Comprehensive Services </h3>
                        <p class="card-text">From perception to installation, we provide back-to-back digital signage solutions. Our team offers effortless guidance, guaranteeing trouble-free execution, steady upkeep, and extraordinary customer service.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-8.webp')}}" class="why-card-img-top"
                        alt="Support Multiple Media Types   ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Support Multiple Media Types   </h3>
                        <p class="card-text"> Our digital signage displays guide a huge range of media formats, facilitating organizations to exhibit high-class images, videos, animations, and vibrant content effectively for ultimate influence.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-9.webp')}}" class="why-card-img-top"
                        alt="Managed by a Single Application   ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Managed by a Single Application  </h3>
                        <p class="card-text"> With inherent signage software, you can command all your signage displays from one platform. This focused perspective smoothens management and makes sure of functional efficiency.</p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-11.webp')}}" class="why-card-img-top"
                        alt="User-Friendly Interface   ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">User-Friendly Interface  </h3>
                        <p class="card-text"> Our interactive flat panels and touchscreen kiosks present easy-to-operate interfaces, making them attainable and comfortable for users of all expertise phases.  
                        </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-12.webp')}}" class="why-card-img-top"
                        alt="Competitive Pricing     ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Competitive Pricing    </h3>
                        <p class="card-text">We offer standardized display solutions at reasonable prices. Whether it’s a digital display board or a usual digital signage display, we ensure the worth of your investment.</p>
                    </div>
                </div>
            </div>
           
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-13.webp')}}" class="why-card-img-top"
                        alt="Customer-Centric Approach     ">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Customer-Centric Approach   </h3>
                        <p class="card-text"> Your contentment is primary for us. We integrate with you at each level to render digital signage that fulfills your expectations and business targets.  </p>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="why-card card">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-14.webp')}}" class="why-card-img-top"
                        alt="Quick Turnaround Time">
                    <div class="card-body why-card-body px-0">
                        <h3 class="why-text-red mb-3">Quick Turnaround Time  </h3>
                        <p class="card-text"> We comprehend the significance of time and make certain of punctual delivery of all projects, from outline to installation.</p>
                    </div>
                </div>
            </div>
        </div>

        <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-4.webp')}}" class="why-card-img-top"
                                    alt="Customizable Designs    ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customizable Designs    </h3>
                                    <p class="card-text">We concentrate on generating customized digital signage displays to fit your particular requirements. Whether it's a polished digital standee display, an advertising display, or a dynamic video wall, we make sure that your signage is exceptional, influential, and lined up with your brand’s recognition.</p>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-5.webp')}}" class="why-card-img-top"
                                    alt="Cutting-Edge Technology ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Cutting-Edge Technology </h3>
                                    <p class="card-text">As a reliable Digital signage manufacturer in Mumbai, we combine modern technology into each product. From touchscreen kiosks to vibrant LED displays and interactive flat panels, our solutions are outlined to allure viewers and improve your communication schemes.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-6.webp')}}" class="why-card-img-top"
                                alt=" Durable and Reliable Products">
                            <div class="card-body why-card-body px-0">
                                <h3 class="why-text-red mb-3"> Durable and Reliable Products</h3>
                                <p class="card-text">Our digital signage products are made to persist. Utilizing superior substances and modern manufacturing policies, we ensure dependability and resistance in indoor and outdoor LED display atmospheres, even under difficult circumstances. </p>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                       
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-7.webp')}}" class="why-card-img-top"
                                    alt="Comprehensive Services ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Comprehensive Services </h3>
                                    <p class="card-text"> From perception to installation, we provide back-to-back digital signage solutions. Our team offers effortless guidance, guaranteeing trouble-free execution, steady upkeep, and extraordinary customer service.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-8.webp')}}" class="why-card-img-top"
                                    alt="Support Multiple Media Types   ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Support Multiple Media Types   </h3>
                                    <p class="card-text"> Our digital signage displays guide a huge range of media formats, facilitating organizations to exhibit high-class images, videos, animations, and vibrant content effectively for ultimate influence.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-9.webp')}}" class="why-card-img-top"
                                    alt="Managed by a Single Application   ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Managed by a Single Application  </h3>
                                    <p class="card-text"> With inherent signage software, you can command all your signage displays from one platform. This focused perspective smoothens management and makes sure of functional efficiency.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                
                        <div class="col-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-11.webp')}}" class="why-card-img-top"
                                    alt="User-Friendly Interface   ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">User-Friendly Interface  </h3>
                                    <p class="card-text"> Our interactive flat panels and touchscreen kiosks present easy-to-operate interfaces, making them attainable and comfortable for users of all expertise phases.  
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-12.webp')}}" class="why-card-img-top"
                                    alt="Competitive Pricing     ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Competitive Pricing    </h3>
                                    <p class="card-text">We offer standardized display solutions at reasonable prices. Whether it’s a digital display board or a usual digital signage display, we ensure the worth of your investment.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-13.webp')}}" class="why-card-img-top"
                                    alt="Customer-Centric Approach     ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customer-Centric Approach   </h3>
                                    <p class="card-text"> Your contentment is primary for us. We integrate with you at each level to render digital signage that fulfills your expectations and business targets.  </p>
                                </div>
                            </div>
                        </div>
            
                </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                
                        <div class="col-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-12.webp')}}" class="why-card-img-top"
                                    alt="Competitive Pricing     ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Competitive Pricing    </h3>
                                    <p class="card-text">We offer standardized display solutions at reasonable prices. Whether it’s a digital display board or a usual digital signage display, we ensure the worth of your investment.</p>
                                </div>
                            </div>
                        </div>
                       
                        <div class="col-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-13.webp')}}" class="why-card-img-top"
                                    alt="Customer-Centric Approach     ">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Customer-Centric Approach   </h3>
                                    <p class="card-text"> Your contentment is primary for us. We integrate with you at each level to render digital signage that fulfills your expectations and business targets.  </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="why-card card">
                                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-14.webp')}}" class="why-card-img-top"
                                    alt="Quick Turnaround Time">
                                <div class="card-body why-card-body px-0">
                                    <h3 class="why-text-red mb-3">Quick Turnaround Time  </h3>
                                    <p class="card-text"> We comprehend the significance of time and make certain of punctual delivery of all projects, from outline to installation.</p>
                                </div>
                            </div>
                        </div>
            
                </div>
                </div>
            </div>
            

            <div class="why-carousel-controls">
                <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                    data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators why-carousel-indicators">
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2">
                </button>
                    <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="2"
                    aria-label="Slide 3">
                    </button>
                    <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="3"
                    aria-label="Slide 3">
                    </button>
            </div>
        </div>
    </div>
</section>



<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <h2 class="hero-title">Types of Digital Signages We Offer </h2>
        <p class="card-text text-center">As a prominent Digital signage manufacturer in Mumbai, we supply personalized display solutions for each requirement. From advertising displays to touchscreen kiosks, our products are crafted to allure your viewers and pull outcomes.</p>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-16.webp')}}" alt="Personalized Designs  " class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Indoor Digital Displays    </h2>
                <p class="brand-description">
                    Our indoor digital signage displays are ideal for retail outlets, offices, and lobbies. They depict dynamic visuals and vibrant content to engross guests and render information effectively.
                </p>
                <h2 class="brand-title">Outdoor Digital Signage </h2>
                <p class="brand-description">
                    Shaped to bear rough weather situations, our outdoor LED displays are perfect for advertisements, promotions, and proclamations. These signage solutions render high observability and extraordinary resistance, making them appropriate for several industries.
                               </p>
                <h2 class="brand-title">Interactive Kiosks    </h2>
                <p class="brand-description">
                    We provide innovative touchscreen kiosks that merge easily operationable interfaces with creative technology. These interactive flat panels are ideal for customer engagement, offering a communicative method to obtain information, browse products, or make orders.
                </p>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">

        <div class="row align-items-center">

            <div class="col-lg-6 order-2 order-lg-1">
                <h2 class="brand-title">LED Video Walls</h2>
                <p class="brand-description">
                    
                    Generate a perpetual impact with our remarkable LED video walls. These large-pattern digital signage displays are ideal for events, exhibitions, and commercial places, rendering enveloping visuals and effortless performance. 
                </p>
                <h2 class="brand-title">Menu Boards for Restaurants     </h2>
                <p class="brand-description">
                    Our made-to-order digital menu boards are crafted to improve your restaurant’s attraction. With easily updated displays, you can illustrate menu stuff, promotions, and daily specials immediately, guaranteeing a smooth customer experience.  
                </p>
                <h2 class="brand-title">Commercial Displays</h2>
                <p class="brand-description">
                    We offer professional-grade commercial displays for offices, retail places, and hospitality industries. These resistant digital signage solutions provide premium performance, dynamic visuals, and powerful operationality customized to fulfill business requirements.
                                </p>
            </div>

            <div class="col-lg-6 mb-4 mb-lg-0  order-1 order-lg-2">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-17.webp')}}" alt="Digital Signage Manufacturers in Mumbai" class="img-fluid">
                </div>
            </div>

        </div>
    </div>
</section>

<section>
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="showcase-image">
                    <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-18.webp')}}" alt="Digital Signage Manufacturers in Mumbai" class="img-fluid">
                </div>
            </div>

            <div class="col-lg-6">
                <h2 class="brand-title">Digital Standee Displays </h2>
                <p class="brand-description">
                    Our polished and contemporary digital standee displays are ideal for promotions, advertisements, and brand awareness programs. Easily to move and simple to set up, these digital signages are a universal solution for several atmospheres.
                </p>
                <p class="brand-description">Opt for us for dependable and inventive digital signage solutions that uplift your brand’s communication. Contact us soon to discover our huge range of digital signage displays personalized to your exceptional needs.
                </p>
            </div>
        </div>
    </div>
</section>



<section class="mt-lg-5">
    <div class="container py-lg-5 py-md-3 py-sm-2 py-3" id="gallery-container">
        <h2 class="hero-title">Catalogue</h2>
        
        <!-- First Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-20.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-20.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai" style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-21.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-21.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-22.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-22.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-23.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-23.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
        </div>
        
        <!-- Second Row -->
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-24.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-24.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-25.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-25.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-26.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-26.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mb-4">
                <a href="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-27.webp')}}" data-lightbox="catalogue" data-title="Image 1">
                <img src="{{asset('frontend/Images/new/digital-signages-manufacturer-in-mumbai-27.webp')}}" class="img-fluid" alt="Digital Signage Manufacturers in Mumbai"  style="width: 100%;">
                </a>
            </div>
        </div>

    </div>
</section>

<section class="testimonial section ">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">“We recently updated our office with their digital signage displays, and the outcomes are remarkable! Their skillfulness as a reliable Digital Signages Manufacturer in Mumbai is unparalleled.</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                           
                            <div>
                                <div class="client-name">Rahul Verma</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The digital standee display we bought is ideal for boosting our events. Their inventive digital signage solutions genuinely went far ahead of our expectations!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            <div>
                                <div class="client-name">Neha Sharma</div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">Our latest outdoor LED display has modified how we publicize. The bright visuals and persistent design are excellent. Strongly suggest their signage solutions!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            
                            <div>
                                <div class="client-name">Vikrant Jain</div>
                              
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">The team generated a general touch screen kiosk for our outlet. It’s easy to operate and has enhanced customer engagement drastically. Superb work on the interactive flat panel!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            
                            <div>
                                <div class="client-name">Anjali Mehta</div>
                             
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col testimonial-small-div">
                <div class="testimonial-card card">
                    <div class="yellow-circle">
                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                    </div>
                    <div class="card-body px-0">
                        <p class="card-text testimonial-card-text">“Their LED display screen and video wall have taken our advertising to the next phase. Unique service and premium class!</p>
                        <hr class="yellow-line">
                        <div class="client-info">
                            
                            <div>
                                <div class="client-name">Siddharth Kapoor</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“We recently updated our office with their digital signage displays, and the outcomes are remarkable! Their skillfulness as a reliable Digital Signages Manufacturer in Mumbai is unparalleled.</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                      
                                        <div>
                                            <div class="client-name">Rahul Verma</div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The digital standee display we bought is ideal for boosting our events. Their inventive digital signage solutions genuinely went far ahead of our expectations!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Neha Sharma</div>
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Our latest outdoor LED display has modified how we publicize. The bright visuals and persistent design are excellent. Strongly suggest their signage solutions!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Vikrant Jain</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="carousel-item">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">Our latest outdoor LED display has modified how we publicize. The bright visuals and persistent design are excellent. Strongly suggest their signage solutions! <br> <br> </p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Vikrant Jain</div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">The team generated a general touch screen kiosk for our outlet. It’s easy to operate and has enhanced customer engagement drastically. Superb work on the interactive flat panel!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Anjali Mehta</div>
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="testimonial-card card">
                                <div class="yellow-circle">
                                    <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                </div>
                                <div class="card-body px-0">
                                    <p class="card-text testimonial-card-text">“Their LED display screen and video wall have taken our advertising to the next phase. Unique service and premium class!</p>
                                    <hr class="yellow-line">
                                    <div class="client-info">
                                        
                                        <div>
                                            <div class="client-name">Siddharth Kapoor</div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>

            <div class="testimonial-carousel-controls">
                <button id="prevButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button id="nextButton" class="testimonial-carousel-control" type="button"
                    data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="carousel-indicators testimonial-carousel-indicators">
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>
        </div>
    </div>
</section>


<section class="faq-section">
    <div class="faq-container">
        <h1 class="faq-title">FAQS</h1>

        <div class="faq-item">
            <button class="faq-question">
                How can digital signage assist my organization in Mumbai?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Digital signage can transform your business by improving brand observability and engrossment. As a prominent Digital signage manufacturer in Mumbai, we offer creative digital signage solutions that depict vibrant content to allure your target audience, enhancing customer communication and fostering sales.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What are the benefits of utilizing digital signage in Mumbai's combative market?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Mumbai's fast-moving market demands advertising that grasps attention. Digital signage displays are unique with dynamic visuals and vibrant content. They are flexible, adjustable, and can be upgraded immediately, making them perfect for staying ahead in a combative environment.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Can digital signage be utilized for indoor and outdoor displays?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Yes, our digital signage solutions serve both indoor and outdoor requirements. Whether you require an interactive flat panel for an outlet or an outdoor LED display for a congested area, we provide resistant and weather-proof alternatives.</p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                What kinds of media can be displayed on digital signage screens?
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Our digital display boards support several media forms, comprising images, videos, animations, and prompt updates. From touchscreen kiosks to video walls, you can render engrossing and vibrant content seamlessly.  </p>
            </div>
        </div>

        <div class="faq-item">
            <button class="faq-question">
                Is it manageable to update content from distant digital signage systems? 
                <i class="faq-icon fa-solid fa-chevron-down"></i>
            </button>
            <div class="faq-answer">
                <p>Definitely! With our modern signage software, you can upgrade the content on your digital signage distance, guaranteeing effortless functions across diverse locations. This aspect improves comfort and permits immediate content updates to fulfill your business requirements. </p>
            </div>
        </div>

    </div>
</section>

@endsection