@extends('frontend.layout.appLayout')
@section('content')
    <section class="carousel-section">
        <div id="imageCarousel" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img src="{{asset('frontend/Images/restaurant-signage1.webp')}}" alt="Slide 1">
                    <div class="carousel-caption-custom">
                        <h1>Best Digital Sign Boards for Restaurants- Menu Displays Boards</h1>
                         <div class="mt-4">
                        <a href="{{route('contact_us')}}" class="custom-btn">Get a Quote</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section>
        <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
            <h2 class="hero-title">Sign Boards for Restaurants- Digital Signage and Digital Menu Boards </h2>

            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <div class="showcase-image">
                        <img src="{{asset('frontend/Images/restaurant-signage2.webp')}}" alt="Cafe Rosco Signage" class="img-fluid">
                    </div>
                </div>

                <div class="col-lg-6">
                    <p class="brand-description">
                        Maybe you have introduced pumpkin-spice-flavored drinks or some special dishes for the summer season at your restaurant. Digital signage has a significant impact on restaurant businesses to showcase offers, menus, happy hours, and more. With digital sign boards for restaurants, you can show the changes in prices, or introduce daily specials with ease. If you use print, you can never show cool animations and transitions, and grab your audience’s attention. We have seen that these visuals can encourage people to enhance their dining experience.
                    </p>
                        <p class="brand-description">
                            So, yes, one reason to ask for a “menu display for restaurant” is aesthetics. You have plenty of options on how to present the information. These boards play a vital role in attracting customers who are looking for some best deals, happy hours, or menu boards. Brand Signages is a premier partner for top businesses in Bangalore & India providing digital sign boards for restaurants. Among the best digital menu board companies, we provide customized sign boards for restaurants. Along with print media advertising, we are also living digitally, making digital menus & sign boards an indispensable asset for your restaurant.

                        </p>                  
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container my-5">
            <h2 class="text-center mb-5 card-heading">Creative Uses of Digital Signage <br> in Restaurants</h2>

            <div class="row g-4 cards-row">
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <img src="{{asset('frontend/Images/restaurant-signage3.webp')}}" class="card-img-top" alt="Retail Signages & Retail Branding">
                        <div class="card-body">
                            <h5 class="card-title">Digital Menu Displays</h5>
                            <p class="card-text">Digital menu boards for restaurants are the best way to display foods and boost sales. Moreover, you can post text and attractive visuals to help people choose and order their favorite products. You can also make them interactive, and mobile-friendly, or curate them for the current holiday or seasonal themes.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <img src="{{asset('frontend/Images/restaurant-signage4.webp')}}" class="card-img-top" alt="Rectangular and Die-cut Signs">
                        <div class="card-body">
                            <h5 class="card-title">Customer Feedback Boards</h5>
                            <p class="card-text">A menu board for restaurants helps owners display customer feedback and allows diners to share their thoughts through QR codes or touchscreens. Positive reviews can be showcased to boost confidence, while constructive feedback helps improve service in real time. This enhances customer experience and fosters trust in the restaurant's commitment to quality.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <img src="{{asset('frontend/Images/restaurant-signage5.webp')}}" class="card-img-top" alt="Storefront Signage">
                        <div class="card-body">
                            <h5 class="card-title">Eye-Catching Visual Content Boards</h5>
                            <p class="card-text">These digital menu boards grab attention with vibrant animations, high-resolution food images, or chef-preparation videos. Such dynamic displays entice diners to explore new menu items and create a more immersive dining environment.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <img src="{{asset('frontend/Images/restaurant-signage6.webp')}}" class="card-img-top" alt="Window Graphics">
                        <div class="card-body">
                            <h5 class="card-title">Promotion/ Offers Digital Boards</h5>
                            <p class="card-text">The restaurant industry can use these menu boards to feature limited-time deals, loyalty programs, or discounts with visually compelling graphics. Real-time updates on happy hours or seasonal offers ensure that customers never miss an opportunity to save or try something new.</p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="why-bg-light-pink py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-4 mb-3 why-text-heading">Benefits of Digital Signages for Restaurants</h2>
               
            </div>

            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none">
                <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/restaurant-signage7.webp')}}" class="why-card-img-top"
                            alt="Directional and Wayfinding Signages">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Enhanced Customer Engagement</h3>
                            <p class="card-text">What is the best way of capturing your audience’s attention? You can put up digital signage that comes with vibrant visuals, animations, and social media reviews (Yelp reviews). You can add a touch of interactivity by adding touchscreens and QR codes. This allows you to build a deeper connection with customers and make them into brand loyalists. <br> <br> <br> </p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/restaurant-signage8.webp')}}" class="why-card-img-top"
                            alt="Informational and Educational Signage">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Increased Sales Opportunities</h3>
                            <p class="card-text">Digital menu boards for restaurants can be used for upselling combos or highlighting seasonal specials, restaurants can drive impulse purchases. Digital signage solutions allow fast food businesses to experiment with content, targeting specific customer preferences at different times of the day. We have seen that these boards can boost average ticket sales and promises.</p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="col-md-4">
                        <div class="why-card card">
                            <img src="{{asset('frontend/Images/restaurant-signage9.webp')}}" class="why-card-img-top"
                                alt="Illuminated Outdoor Signage">
                            <div class="card-body why-card-body px-0">
                                <h3 class="why-text-red mb-3">Improved Brand Visibility</h3>
                                <p class="card-text">As an owner, how can you captivate buyers? You can place digital signage for restaurants throughout your space. You can showcase your brand through attractive images, videos, and animations. If you use these signboards correctly, you can enhance your brand's recall</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="why-card card">
                        <img src="{{asset('frontend/Images/restaurant-signage10.webp')}}" class="why-card-img-top"
                            alt="Branding Signages">
                        <div class="card-body why-card-body px-0">
                            <h3 class="why-text-red mb-3">Streamlined Communication and Operations</h3>
                            <p class="card-text">Digital menu boards for restaurants offer a simpler channel of communication between diners and owners. Cafes can share real-time updates to let your customers know they are valued and taken care of.  This reduces the need for physical reprints and minimizes errors in customer communication. Additionally, they can be used for internal purposes, such as displaying staff schedules or operational updates, ensuring smoother coordination within the team.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div id="signageCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <div class="row">

                            <div class="col-md-4">
                                <div class="why-card card">
                                    <img src="{{asset('frontend/Images/restaurant-signage7.webp')}}" class="why-card-img-top"
                                        alt="Directional and Wayfinding Signages">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Enhanced Customer Engagement</h3>
                                        <p class="card-text">What is the best way of capturing your audience’s attention? You can put up digital signage that comes with vibrant visuals, animations, and social media reviews (Yelp reviews). You can add a touch of interactivity by adding touchscreens and QR codes. This allows you to build a deeper connection with customers and make them into brand loyalists. <br> <br> <br> </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="why-card card">
                                    <img src="{{asset('frontend/Images/restaurant-signage8.webp')}}" class="why-card-img-top"
                                        alt="Informational and Educational Signage">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Increased Sales Opportunities</h3>
                                        <p class="card-text">Digital menu boards for restaurants can be used for upselling combos or highlighting seasonal specials, restaurants can drive impulse purchases. Digital signage solutions allow fast food businesses to experiment with content, targeting specific customer preferences at different times of the day. We have seen that these boards can boost average ticket sales and promises.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="why-card card">
                                    <img src="{{asset('frontend/Images/restaurant-signage9.webp')}}" class="why-card-img-top"
                                        alt="Illuminated Outdoor Signage">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Improved Brand Visibility</h3>
                                        <p class="card-text">As an owner, how can you captivate buyers? You can place digital signage for restaurants throughout your space. You can showcase your brand through attractive images, videos, and animations. If you use these signboards correctly, you can enhance your brand's recall</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="why-card card">
                                    <img src="{{asset('frontend/Images/restaurant-signage8.webp')}}" class="why-card-img-top"
                                        alt="Illuminated Outdoor Signage">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Increased Sales Opportunities</h3>
                                        <p class="card-text">Digital menu boards for restaurants can be used for upselling combos or highlighting seasonal specials, restaurants can drive impulse purchases. Digital signage solutions allow fast food businesses to experiment with content, targeting specific customer preferences at different times of the day. We have seen that these boards can boost average ticket sales and promises.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="why-card card">
                                    <img src="{{asset('frontend/Images/restaurant-signage9.webp')}}" class="why-card-img-top"
                                        alt="Digital Signages">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Improved Brand Visibility</h3>
                                        <p class="card-text">As an owner, how can you captivate buyers? You can place digital signage for restaurants throughout your space. You can showcase your brand through attractive images, videos, and animations. If you use these signboards correctly, you can enhance your brand's recall</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="why-card card">
                                    <img src="{{asset('frontend/Images/restaurant-signage10.webp')}}" class="why-card-img-top"
                                        alt="Branding Signages">
                                    <div class="card-body why-card-body px-0">
                                        <h3 class="why-text-red mb-3">Streamlined Communication and Operations</h3>
                                        <p class="card-text">Digital menu boards for restaurants offer a simpler channel of communication between diners and owners. Cafes can share real-time updates to let your customers know they are valued and taken care of.  This reduces the need for physical reprints and minimizes errors in customer communication. Additionally, they can be used for internal purposes, such as displaying staff schedules or operational updates, ensuring smoother coordination within the team.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="why-carousel-controls">
                    <button id="prevButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                        data-bs-slide="prev">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button id="nextButton" class="why-carousel-control" type="button" data-bs-target="#signageCarousel"
                        data-bs-slide="next">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>

                <div class="carousel-indicators why-carousel-indicators">
                    <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="0" class="active"
                        aria-label="Slide 1"></button>
                    <button type="button" data-bs-target="#signageCarousel" data-bs-slide-to="1"
                        aria-label="Slide 2"></button>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container py-lg-5 py-md-3 py-sm-2 py-3">
            <h2 class="hero-title">Why Choose Us for Restaurant <br> Digital Signages</h2>

            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <div class="showcase-image">
                        <img src="{{asset('frontend/Images/restaurant-signage11.webp')}}" alt="Cafe Rosco Signage" class="img-fluid">
                    </div>
                </div>

                <div class="col-lg-6">
                    <p class="brand-description">
                        You now know the benefits of using high-quality digital signage for restaurants, and now you want to make the best out of the situation. But why should you hire us among all the other digital menu board companies available today? Reason one, you will get tailored solutions. We will create boards that match your vision and specific changes. Do you think that digital signage is only for large cafes and restaurants? Well, you are wrong, as we believe everyone deserves a chance, a voice. When you install these menu boards, you are likely to bring in more customers, boost sales, and be visible to millions of people.</p>
                    <p class="brand-description">
                        Digital signages should not be complicated, and we are a firm believer of this principle. We have simplified the process by using user-friendly content management software. We will help you manage these systems even if you don’t have technical expertise. You can adapt as per changing timelines, real-time updates, and other announcements.</p>
                    <p class="brand-description">
                        Our team will provide end-to-end support, from consultation to installation and maintenance. And do you know about the best part? We will do all these at reasonable prices, so you don’t have to break your bank. If you need a dedicated partner, hit us up.</p>
                    
                </div>
            </div>
        </div>
    </section>

    <section class="testimonial section ">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-4 mb-3 why-text-heading">Customer Testimonial</h2>
            </div>

            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 d-md-none ">
                <div class="col testimonial-small-div">
                    <div class="testimonial-card card">
                        <div class="yellow-circle">
                            <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                        </div>
                        <div class="card-body px-0">
                            <p class="card-text testimonial-card-text">The digital menu boards transformed the way we present our dishes! Customers love the vibrant visuals, and updating menus has never been easier.</p>
                            <hr class="yellow-line">
                            <div class="client-info">
                                <img src="{{asset('frontend/Images/restaurant-signage12.webp')}}" alt="Client 1" class="client-img">
                                <div>
                                    <div class="client-name">Sarah</div>
                                    <div class="client-role">Café Owner</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col testimonial-small-div">
                    <div class="testimonial-card card">
                        <div class="yellow-circle">
                            <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                        </div>
                        <div class="card-body px-0">
                            <p class="card-text testimonial-card-text">"We’ve seen a noticeable increase in sales since installing digital signages. When we started highlighting our products, we have seen a visible increase in sales.</p>
                            <hr class="yellow-line">
                            <div class="client-info">
                                <img src="{{asset('frontend/Images/restaurant-signage13.webp')}}" alt="Client 1" class="client-img">
                                <div>
                                    <div class="client-name">Pooja Singh</div>
                                    <div class="client-role">Fusion Cuisine Restaurant Owner</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col testimonial-small-div">
                    <div class="testimonial-card card">
                        <div class="yellow-circle">
                            <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                        </div>
                        <div class="card-body px-0">
                            <p class="card-text testimonial-card-text">We thought the process would be complex, but the team has simplified it for us – Navin, Franchise owner</p>
                            <hr class="yellow-line">
                            <div class="client-info">
                                <img src="{{asset('frontend/Images/restaurant-signage14.webp')}}" alt="Client 1" class="client-img">
                                <div>
                                    <div class="client-name">Amarjeet Chawla</div>
                                    <div class="client-role">Punjabi Dhaba Owner</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col testimonial-small-div">
                    <div class="testimonial-card card">
                        <div class="yellow-circle">
                            <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                        </div>
                        <div class="card-body px-0">
                            <p class="card-text testimonial-card-text">Our branding really comes alive with the digital displays. It’s helped us stand out in a crowded market.</p>
                            <hr class="yellow-line">
                            <div class="client-info">
                                <img src="{{asset('frontend/Images/restaurant-signage15.webp')}}" alt="Client 1" class="client-img">
                                <div>
                                    <div class="client-name">Ishika</div>
                                    <div class="client-role">Bistro Owner</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col testimonial-small-div">
                    <div class="testimonial-card card">
                        <div class="yellow-circle">
                            <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                        </div>
                        <div class="card-body px-0">
                            <p class="card-text testimonial-card-text">The ability to make real-time updates has saved us so much time and money. Highly recommend their services!</p>
                            <hr class="yellow-line">
                            <div class="client-info">
                                <img src="{{asset('frontend/Images/restaurant-signage16.webp')}}" alt="Client 1" class="client-img">
                                <div>
                                    <div class="client-name">Namrata</div>
                                    <div class="client-role">Fast-Food Chain Manager</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="testimonialCarousel" class="carousel slide d-none d-md-block" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="testimonial-card card">
                                    <div class="yellow-circle">
                                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                    </div>
                                    <div class="card-body px-0">
                                        <p class="card-text testimonial-card-text">The digital menu boards transformed the way we present our dishes! Customers love the vibrant visuals, and updating menus has never been easier.</p>
                                        <hr class="yellow-line">
                                        <div class="client-info">
                                            <img src="{{asset('frontend/Images/restaurant-signage12.webp')}}" alt="Client 1" class="client-img">
                                            <div>
                                                <div class="client-name">Sarah</div>
                                                <div class="client-role">Café Owner</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="testimonial-card card">
                                    <div class="yellow-circle">
                                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                    </div>
                                    <div class="card-body px-0">
                                        <p class="card-text testimonial-card-text">"We’ve seen a noticeable increase in sales since installing digital signages. When we started highlighting our products, we have seen a visible increase in sales.</p>
                                        <hr class="yellow-line">
                                        <div class="client-info">
                                            <img src="{{asset('frontend/Images/restaurant-signage13.webp')}}" alt="Client 1" class="client-img">
                                            <div>
                                                <div class="client-name">Pooja Singh</div>
                                                <div class="client-role">Fusion Cuisine Restaurant Owner</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="testimonial-card card">
                                    <div class="yellow-circle">
                                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                    </div>
                                    <div class="card-body px-0">
                                        <p class="card-text testimonial-card-text">We thought the process would be complex, but the team has simplified it for us – Navin, Franchise owner</p>
                                        <hr class="yellow-line">
                                        <div class="client-info">
                                            <img src="{{asset('frontend/Images/restaurant-signage14.webp')}}" alt="Client 1" class="client-img">
                                            <div>
                                                <div class="client-name">Amarjeet Chawla</div>
                                                <div class="client-role">Punjabi Dhaba Owner</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="testimonial-card card">
                                    <div class="yellow-circle">
                                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                    </div>
                                    <div class="card-body px-0">
                                        <p class="card-text testimonial-card-text">We thought the process would be complex, but the team has simplified it for us – Navin, Franchise owner <br> <br> </p>
                                        <hr class="yellow-line">
                                        <div class="client-info">
                                            <img src="{{asset('frontend/Images/restaurant-signage14.webp')}}" alt="Client 1" class="client-img">
                                            <div>
                                                <div class="client-name">Amarjeet Chawla</div>
                                                <div class="client-role">Punjabi Dhaba Owner</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="testimonial-card card">
                                    <div class="yellow-circle">
                                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                    </div>
                                    <div class="card-body px-0">
                                        <p class="card-text testimonial-card-text">Our branding really comes alive with the digital displays. It’s helped us stand out in a crowded market.</p>
                                        <hr class="yellow-line">
                                        <div class="client-info">
                                            <img src="{{asset('frontend/Images/restaurant-signage15.webp')}}" alt="Client 1" class="client-img">
                                            <div>
                                                <div class="client-name">Ishika</div>
                                                <div class="client-role">Bistro Owner</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="testimonial-card card">
                                    <div class="yellow-circle">
                                        <img src="{{asset('frontend/Images/comment-icon.webp')}}" alt="Comment" class="comment-img">
                                    </div>
                                    <div class="card-body px-0">
                                        <p class="card-text testimonial-card-text">The ability to make real-time updates has saved us so much time and money. Highly recommend their services!</p>
                                        <hr class="yellow-line">
                                        <div class="client-info">
                                            <img src="{{asset('frontend/Images/restaurant-signage16.webp')}}" alt="Client 1" class="client-img">
                                            <div>
                                                <div class="client-name">Namrata</div>
                                                <div class="client-role">Fast-Food Chain Manager</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>

                <div class="testimonial-carousel-controls">
                    <button id="prevButton" class="testimonial-carousel-control" type="button"
                        data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button id="nextButton" class="testimonial-carousel-control" type="button"
                        data-bs-target="#testimonialCarousel" data-bs-slide="next">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>

                <div class="carousel-indicators testimonial-carousel-indicators">
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"
                        aria-label="Slide 1"></button>
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"
                        aria-label="Slide 2"></button>
                </div>
            </div>
        </div>
    </section>

    <section class="faq-section">
        <div class="faq-container">
            <h1 class="faq-title">FAQS</h1>

            <div class="faq-item">
                <button class="faq-question">
                    How does digital signage improve the customer experience in restaurants?
                    <i class="faq-icon fa-solid fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>The short answer is yes, they can improve customer experience in restaurants. You can ensure your diners have a great time while dining by showing engaging visuals of your latest menu, promotions, and specials. 
                       <br>
                       It simplifies decision-making with clear, dynamic content, reduces perceived wait times through entertainment, and ensures up-to-date information. This modern, interactive approach leaves a lasting impression on diners.
                    </p>
                </div>
            </div>

            <div class="faq-item">
                <button class="faq-question">
                    Can digital menu boards be customized for different meal times or promotions?
                    <i class="faq-icon fa-solid fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes, digital menu boards can be easily customized for different meal times or promotions. With scheduling features, you can automatically switch displays for breakfast, lunch, or dinner menus. They also allow real-time updates, enabling you to highlight limited-time offers, seasonal dishes, or special events seamlessly, enhancing customer engagement and sales.</p>
                </div>
            </div>

            <div class="faq-item">
                <button class="faq-question">
                    What types of content can be displayed on restaurant digital signage?
                    <i class="faq-icon fa-solid fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Restaurant digital signage can display a wide variety of content, including:</p>
                    <ul>
                        <li>Menus: Dynamic menus with vibrant images, item descriptions, prices, and nutritional details.</li>
                        <li>Promotions: Limited-time offers, discounts, combo deals, or happy hour specials.</li>
                        <li>Videos: Engaging food preparation clips or customer testimonials.</li>
                        <li>Brand Content: Logos, taglines, or branding animations to enhance identity.</li>
                        <li>Entertainment: Trivia, social media feeds, or news to reduce perceived wait times.</li>
                        <li>Internal Messaging: Staff schedules, training updates, or safety announcements.</li>
                    </ul>
                </div>
            </div>

            <div class="faq-item">
                <button class="faq-question">
                    How does digital signage help increase sales and revenue?
                    <i class="faq-icon fa-solid fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>The digital signage is necessary as a primary communication tool about your offerings. But you can use them in multiple ways to upsell and cross sell, and increase your sales and revenue by sharing combos.
                       <br>
                       Additionally, real-time updates allow restaurants to adjust pricing or feature items based on demand, reducing waste and maximizing profitability. Engaging content also enhances the customer experience, encouraging repeat visits and boosting loyalty.
                    </p>
                </div>
            </div>

            <div class="faq-item">
                <button class="faq-question">
                    Is digital signage easy for restaurant staff to update and manage?
                    <i class="faq-icon fa-solid fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>We have curated a simplified system that helps staff to take care of digital signage. We will provide access to our intuitive software, which will make content management significantly easier. They can make changes to the menu and other data to show to your customers.</p>
                </div>
            </div>

        </div>
    </section>
@endsection